import system:util.*;

public class Vector
{
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public Vector(int initialCapacity, int capacityIncrement) 
	{
		super();
		this.elementData = new Object[initialCapacity];
		this.capacityIncrement = capacityIncrement;
    }

    public Vector(int initialCapacity) 
	{
		this(initialCapacity, 0);
    }

    public Vector() 
	{
		 this(10);
    }

    /**
     * Copies the components of this vector into the specified array. 
     * The array must be big enough to hold all the objects in this  vector.
     */
    public final synchronized void copyInto(Object[] anArray) 
	{
		int i = elementCount;
		while (i-- > 0) 
		{
			anArray[i] = elementData[i];
		}
    }

    /**
     * Trims the capacity of this vector to be the vector's current 
     * size. An application can use this operation to minimize the 
     * storage of a vector. 
     */
    public final synchronized void trimToSize() 
	{
		int oldCapacity = elementData.length;
		if (elementCount < oldCapacity) 
		{
			Object[] oldData = elementData;
			elementData = new Object[elementCount];
			System.arraycopy(oldData, 0, elementData, 0, elementCount);
		}
    }

    /**
     * Increases the capacity of this vector, if necessary, to ensure 
     * that it can hold at least the number of components specified by 
     * the minimum capacity argument. 
     */
    public final synchronized void ensureCapacity(int minCapacity) 
	{
		if (minCapacity > elementData.length) 
		{
			ensureCapacityHelper(minCapacity);
		}
    }

    /**
     * This implements the unsynchronized semantics of ensureCapacity.
     * Synchronized methods in this class can internally call this 
     * method for ensuring capacity without incurring the cost of an 
     * extra synchronization.
     */ 

	private void ensureCapacityHelper(int minCapacity) 
	{
		int oldCapacity = elementData.length;
		Object[] oldData = elementData;

//		int newCapacity = (capacityIncrement > 0) ? (oldCapacity + capacityIncrement) : (oldCapacity * 2);
//helyette:
		int newCapacity;
		if( capacityIncrement > 0 )
			newCapacity = (oldCapacity + capacityIncrement);
		else
			newCapacity = (oldCapacity * 2);
//---
		
		if (newCapacity < minCapacity) 
		{
			newCapacity = minCapacity;
		}
		elementData = new Object[newCapacity];
		System.arraycopy(oldData, 0, elementData, 0, elementCount);
    }
    
    /**
     * Sets the size of this vector. If the new size is greater than the 
     * current size, new <code>null</code> items are added to the end of 
     * the vector. If the new size is less than the current size, all 
     * components at index <code>newSize</code> and greater are discarded.
     */
    public final synchronized void setSize(int newSize) 
	{
		if ((newSize > elementCount) && (newSize > elementData.length)) 
		{
			ensureCapacityHelper(newSize);
		} 
		else
		{
			for (int i = newSize ; i < elementCount ; i++) 
			{
			elementData[i] = null;
			}
		}
		elementCount = newSize;
    }

    public final int capacity() 
	{
		return elementData.length;
    }

    public final int size() 
	{
		return elementCount;
    }

    public final int isEmpty() 
	{
		return elementCount == 0;
    }

    public final int contains(Object elem) 
	{
		return indexOf(elem, 0) >= 0;
    }

    public final int indexOf(Object elem) 
	{
		return indexOf(elem, 0);
    }

    public final synchronized int indexOf(Object elem, int index) 
	{
		for (int i = index ; i < elementCount ; i++) 
		{
			if (elem.equals(elementData[i])) 
			{
				return i;
			}
		}
		return -1;
    }

    public final int lastIndexOf(Object elem) 
	{
		return lastIndexOf(elem, elementCount-1);
    }

    public final synchronized int lastIndexOf(Object elem, int index) 
	{
		for (int i = index ; i >= 0 ; i--) 
		{
			if (elem.equals(elementData[i])) 
			{
				return i;
			}
		}
		return -1;
    }

    public final synchronized Object elementAt(int index) 
	{
//		if (index >= elementCount) 
//		{
//			throw new ArrayIndexOutOfBoundsException(index + " >= " + elementCount);
//		}
		return elementData[index];
    }

    public final synchronized Object firstElement() 
	{
//		if (elementCount == 0) 
//		{
//	    throw new NoSuchElementException();
//		}
		return elementData[0];
    }

    public final synchronized Object lastElement() 
	{
		if (elementCount == 0) 
		{
			//return elementData[-1];
			return null;
//			throw new NoSuchElementException();
		}
		return elementData[elementCount - 1];
    }

    public final synchronized Object removeLastElement() 
	 {
		if (elementCount == 0) 
		{
			return elementData[-1];
//			throw new NoSuchElementException();
		}

		Object	lastElement = elementData[elementCount - 1];
		elementData[--elementCount] = null;
		return lastElement;
    }

    public final synchronized void setElementAt(Object obj, int index) 
	 {
//		if (index >= elementCount) 
//		{
//			throw new ArrayIndexOutOfBoundsException(index + " >= " + elementCount);
//		}
		elementData[index] = obj;
    }

    public final synchronized Object removeElementAt(int index) 
	 {
/*		if (index >= elementCount) 
		{
			throw new ArrayIndexOutOfBoundsException(index + " >= " + elementCount);
		}
		else
			if (index < 0) 
			{
				throw new ArrayIndexOutOfBoundsException(index);
			}
*/
		Object	removedElement = elementData[index];

		int j = elementCount - index - 1;
		if (j > 0) 
		{
			System.arraycopy(elementData, index + 1, elementData, index, j);
		}
		elementCount--;
		elementData[elementCount] = null; /* to let gc do its work */

		return removedElement;
    }

    public final synchronized void insertElementAt(Object obj, int index) 
	 {
		if( obj )
		{
			int newcount = elementCount + 1;
	//		if (index >= newcount) 
	//		{
	//			throw new ArrayIndexOutOfBoundsException(index + " > " + elementCount);
	//		}
			if (newcount > elementData.length) 
			{
				ensureCapacityHelper(newcount);
			}
			System.arraycopy(elementData, index, elementData, index + 1, elementCount - index);
			elementData[index] = obj;
			elementCount++;
		}
    }

    public final synchronized void addElement(Object obj) 
	{
		if( obj )
		{
			int newcount = elementCount + 1;
			if (newcount > elementData.length) 
			{
				ensureCapacityHelper(newcount);
			}
			elementData[elementCount++] = obj;
		}
	}

    public final synchronized int removeElement(Object obj) 
	 {
		int i = indexOf(obj);
		if (i >= 0) 
		{
			removeElementAt(i);
			return true;
		}
		return false;
    }

    public final synchronized void removeAllElements() 
	 {
		for (int i = 0; i < elementCount; i++) 
		{
			elementData[i] = null;
		}
		elementCount = 0;
    }
/*
    public final synchronized String toString() 
	 {
		int max = size() - 1;
		StringBuffer buf = new StringBuffer();
		Enumeration e = elements();
		buf.append("[");

		for (int i = 0 ; i <= max ; i++) 
		{
			String s = e.nextElement().toString();
			buf.append(s);
			if (i < max) 
			{
				buf.append(", ");
			}
		}
		buf.append("]");
		return buf.toString();
    }
*/
}

