import system:util.*;

import system:io.*;
import system:util.resource.*;
import system:sound.*;

public class Config extends GameType
{
	// option values
	final static int	HIGH = 2;
	final static int	MID  = 1;
	final static int	LOW  = 0;
	final static int	OFF  = -1;
	
	// texture detail options
	//meaning: 
	final static int	texture_size_high = 0;          // must be different!
	final static int	texture_size_mid  = 2;
	final static int	texture_size_low  = 3;

	// shadow detail options
	final static int	shadows_high = 2;
	final static int	shadows_mid  = 2;
	final static int	shadows_low  = 2;       //1 nem mukodik!
	final static int	shadows_off  = 0;

	final static int	shadow_size_high = 512;
	final static int	shadow_size_mid  = 256;
	final static int	shadow_size_low  = 128;
	final static int	shadow_size_off  = 64;

	final static float	shadow_detail_high = 0.1;         // must be different!
	final static float	shadow_detail_mid  = 0.25;
	final static float	shadow_detail_low  = 0.5;
	final static float	shadow_detail_off  = 10.0;
	//----------------------------------------------------------------------------------

	//version information:
	static	String		version = "v2.1.9r5";
	static	int			acceptBuild = 599;	//ennel kisebb build-szamu exe eseten hibat jelez!

	//main render settings:
	static int			video_windowed = 0;
	static int			video_x = 800;
	static int			video_y = 600;
	static int			video_depth = 32;
	static float		video_gamma = 1.0;
	static int			SysCursor = 1;
	static int			Sound_3D_HW = 2;
	static int			Sound_Mix_HW = 2;

	//debug settings:
	static int          loadConfigEnabled = 1;  //
	static int			majomParade = 0;                //enables all cheat buttons, cheat keys, etc.

	//initial gametype to load (after Config.class)
	static	int			init = sl:0x0040r;

	//texture
	static int			texture_size = 2;
	static float		texture_save_quality = 1.0;
	static int			texture_format = 3;
	//shadow
	static int			shadow_size = 256;		//2-es shadow settingsnel szamit 
	static float		shadow_detail = 0.25f;  //2-es shadow settingsnel szamit
	static int			shadows = 2;			//0-nincs, 1-folt, 2-real time rendered

	static int			flares = 1;
	static int			headlight_rays = 1;


	static  float		object_detail = 0.0345;
	static  float		object_detail_amp = 13.0;

	static float		particle_density = 0.6;

	static float		trafficDensity = 1.0;
	static float		pedestrianDensity = 0;

	//internal camera settings
	static float		camera_int_clipplane = 0.1;
	static float		camera_int_viewrange = 200.0;

	//external camera settings
	static float		camera_ext_clipplane = 0.2;
	static float		camera_ext_viewrange = 200.0;

	//camera settings
	static float		camera_AOV = 55.0;
	static float		camera_torque = 0.02;
	static float		camera_force = 2.0;
	static float		camera_damping = 1.0;
	static float		camera_perpdamping = 0.7;
	static float		camera_max_force = 20.0;

	static float		camera_look_ahead = 0.0;
	static float		camera_go_behind = 0.0;
	static float		camera_go_above = 0.0;
	static float		camera_distance = 5.0;
	static float		camera_FOV = 1.25*0.5;

	static float		head_move_steer = 1.0;
	static float		head_move_vel = 1.0;
	static float		head_move_acc = 1.0;

	static int			camera_render = 0;
	static int			camera_nocollision = 0; //to make a playable framerate even at Comm.area


	static	int			metricSystem = 1;	//0-mile, 1-km
	static	int			gpsMode;

	//0:manual+autoclutch 1:auto+autclutch 2:manual+clutch [3:auto+clutch] 5:semiauto [7:semiauto+clutch]
	static int			player_transmission = 1;
	static float		player_steeringhelp = 0.666;
	static float		player_abs = 0.0;
	static float		player_asr = 0.0;
	static float		player_esp = 0.0;

	static float		deformation = 0.6;
	static float		external_damage = 0.25;
	static float		internal_damage = 1.0;

	static float		player_damage_multiplier = 0.8;
	static float		player_change_distance = 10.0;
	static float		player_change_velocity = 2.0;
	static int			player_display = 0x0;//0x0201;
	static int			MouseHelp = 0;

	static	float		wheel_gndfeedback_factor= 7.0;
	static	float		wheel_brake_factor	= 6.0;
	static	float		engine_inertia_factor	= 6.0;

	static float		target_angle_weight = 0.5f;

	static float		controller_deadzone = 0.00f;
	static float		mouseSensitivity = 0.8f;                // 0.0 .. 1.0

	static int			ForceFeedBack = 1;
	static float		FFB_strength = 1.0f;
	static float		FFB_strength_emulated = 0.0333;

	//physics settings
	static float		gravity = 9.81;                 //normal earth gravity
	static float		ground_friction = 1.0;
	static int			ground_precache = 0;

	//resource settings
	static int			resource_refreshrate = 1024;
	static int			resource_loadrate = 128;

	static int			mem_vertex_max  = (20*1024*1024);
	static int			mem_vertex_min  = (16*1024*1024);
	static int			mem_texture_max = (48*1024*1024);
	static int			mem_texture_min = (40*1024*1024);
	static int			mem_instance_max= (4500);
	static int			mem_instance_min= (4000);
	static int			mem_sound_max = (16*1024*1024);
	static int			mem_sound_min = (12*1024*1024);

	static int			skidmark_max = 4096;

	//display arrows pointing to the opposition in multiplayer?
	static int			mp_arrows_on = 1; 

	static float		deadZoneAccelerate = 0.0;
	static float		deadZoneBrake = 0.0;
	static float		deadZoneSteering = 0.0;
	static float		deadZoneClutch = 0.0;

	static float		throttleSpeed = 0.0200f;
	static float		brakeSpeed =    0.0200f;
	static float		steerSpeed =    0.0100f;
	static float		steerhelp_turn = 1.0f;

	static float		throttlePower = 2.5f;
	static float		brakePower = 2.5f;
	static float		steeringPower = 1.5f;
	static float		clutchPower = 2.5f;

//-----------------------------------------------------------------------------------------

	final static int SAVEFILEID = 0xFEDCBA98;
	final static int SAVEFILEVERSION = 12;

	public Config( int id )
	{
		if( !loadConfig( "save/game/options" ) )
		{
			//variableless default settings
			Sound.setVolume( Sound.CHANNEL_EFFECTS, 1.0 );
			Sound.setVolume( Sound.CHANNEL_MUSIC,  0.5 );
			Sound.setVolume( Sound.CHANNEL_ENGINE, 1.0 );
		}
	}

	public void finalize()
	{
		saveConfig( "save/game/options" );
		super.finalize();
	}

	public int saveConfig( String filename )
	{
		File.delete( filename );

		File f = new File( filename );
		if( f.open( File.MODE_WRITE ) )
		{
			f.write( SAVEFILEID );
			f.write( SAVEFILEVERSION );

			f.write( video_windowed );
			f.write( video_x );
			f.write( video_y );
			f.write( video_depth );
			f.write( video_gamma );

			f.write( texture_size );

			f.write( shadow_size );
			f.write( shadow_detail );
			f.write( shadows );

			f.write( camera_ext_viewrange );
			f.write( camera_int_viewrange );

			f.write( flares );
			f.write( headlight_rays );

			f.write( particle_density );

			f.write( object_detail );
			f.write( object_detail_amp );

			f.write( player_transmission );
			f.write( player_steeringhelp );
			f.write( player_asr );
			f.write( player_abs );

			f.write( player_damage_multiplier );
			f.write( deformation );
			f.write( internal_damage );

			f.write( trafficDensity );
			f.write( pedestrianDensity );

			f.write( mouseSensitivity );

			f.write( Sound.getVolume( Sound.CHANNEL_EFFECTS ) );
			f.write( Sound.getVolume( Sound.CHANNEL_MUSIC  ) );
			f.write( Sound.getVolume( Sound.CHANNEL_ENGINE ) );

			f.write( metricSystem );
			f.write( gpsMode );

			f.write( FFB_strength );
			f.write( FFB_strength_emulated );

			f.write( Sound_3D_HW );
			f.write( Sound_Mix_HW );

			f.write( head_move_steer );
			f.write( head_move_vel );
			f.write( head_move_acc );

			f.close();
			return 1;
		}
		return 0;
	}

	public int loadConfig( String filename )
	{
		int	success;

		File f = new File( filename );
		if( loadConfigEnabled )
		{
			if( f.open( File.MODE_READ ) )
			{
				if( f.readInt() == SAVEFILEID )
				{
					if( f.readInt() == SAVEFILEVERSION )
					{
						video_windowed = f.readInt();
						video_x = f.readInt();
						video_y = f.readInt();
						video_depth = f.readInt();
						video_gamma = f.readFloat();

						texture_size = f.readInt();

						shadow_size = f.readInt();
						shadow_detail = f.readFloat();
						shadows = f.readInt();

						camera_ext_viewrange = f.readFloat();
						camera_int_viewrange = f.readFloat();

						flares = f.readInt();
						headlight_rays = f.readInt();

						particle_density = f.readFloat();

						object_detail = f.readFloat();
						object_detail_amp = f.readFloat();

						player_transmission = f.readInt();
						player_steeringhelp = f.readFloat();
						player_asr = f.readFloat();
						player_abs = f.readFloat();

						player_damage_multiplier = f.readFloat();
						deformation = f.readFloat();
						internal_damage = f.readFloat();

						trafficDensity = f.readFloat();
						pedestrianDensity = f.readFloat();

						mouseSensitivity = f.readFloat();

						Sound.setVolume( Sound.CHANNEL_EFFECTS, f.readFloat() );
						Sound.setVolume( Sound.CHANNEL_MUSIC,  f.readFloat() );
						Sound.setVolume( Sound.CHANNEL_ENGINE, f.readFloat() );

						metricSystem = f.readInt();
						gpsMode = f.readInt();

						FFB_strength = f.readFloat();
						FFB_strength_emulated = f.readFloat();

						Sound_3D_HW = f.readInt();
						Sound_Mix_HW = f.readInt();

						head_move_steer = f.readFloat();
						head_move_vel = f.readFloat();
						head_move_acc = f.readFloat();

						success=1;
					}
				}
				f.close();
			}
		}

		if( metricSystem == 0 )
			System.setMeasure( 1600 );
		else
			System.setMeasure( 1000 );

		return success;
	}


	//cseles cucc..
	public	int	FILD = 1;
}


public class VideoMode
{
	float width, height;
	int	depth;
	int	windowed;

	public VideoMode( float w, float h, int d, int win )
	{
		width=w;
		height=h;
		depth=d;
		windowed=win;
	}
}
