import system:util.resource.*;

public class SfxRef extends ResourceRef
{
	final public static int SFX_NONE		= 0x00000000;
	final public static int SFX_LOOP		= 0x00000001;
	final public static int SFX_NOAUTOSTOP	= 0x80000000;

	public SfxRef(){ super(); }
	public SfxRef( int id ){ super( id ); }
		
	//2D
	public int play()
	{ 
		cache();
		return nplay( null, 0.0, 1.0, 1.0, SFX_NONE, 0 ); 
	}
	public int play( float pitch, float volume, int flags )
	{
		cache();
		return nplay( null, 0.0, pitch, volume, flags, 0 );
	}

	//3D
	public int play( Vector3 pos, float radius, float pitch, float volume, int flags )
	{
		cache();
		return nplay( pos, radius, pitch, volume, flags, 0 );
	}
	public int play( Vector3 pos, float radius, float pitch, float volume, int flags, int instance )
	{
		cache();
		return nplay( pos, radius, pitch, volume, flags, instance );
	}

	//atadhatom neki eleve az snd-instance id-t, es ha mar van ilyen hang, nem indit ujat
	private native int  nplay( Vector3 pos, float radius, float pitch, float volume, int flags, int instance );
	public native void stop( int instance );

}
