import system:util.resource.*;

public class ResourceRef extends Native
{
	final static int	RESTYPE_INVALID				= 0;
	final static int	INSTANCE_GAME				= 1;
	final static int	INSTANCE_PHYSICS			= 2;
	final static int	INSTANCE_RENDER				= 3;
	final static int	RESOURCE_FORCEFX			= 4;
	final static int	RESOURCE_MESH				= 5;
	final static int	RESOURCE_SOUND				= 6;
	final static int	RESOURCE_TEXTURE			= 7;
	final static int	RESTYPE_GAME				= 8;
	final static int	RESTYPE_PHYSICS_BODY		= 9;
	final static int	RESTYPE_PHYSICS_CONSTRAINT	= 10;
	final static int	RESTYPE_PHYSICS_PARTICLE	= 11;
	final static int	RESTYPE_RENDER_CAMERA		= 12;
	final static int	RESTYPE_RENDER_LIGHT		= 13;
	final static int	RESTYPE_RENDER_OBJECT		= 14;
	final static int	INSTANCE_RENDER_SPRITE		= 15;
	final static int	INSTANCE_RENDER_TEXT		= 16;
	final static int	INSTANCE_RENDER_HORIZON		= 17;
	final static int	RESOURCE_VIEWPORT			= 18;
	final static int	RESOURCE_ANIMATION			= 19;
	final static int	RESTYPE_RENDER_MICROPHONE	= 20;
	final static int	RESOURCE_SOUNDMIXER			= 21;
	final static int	RESTYPE_MAX					= 22;

	//automatikusak lehetnenek, a hivasuk is!! (kerdes mi van ha parameterezni kell..)
	public native void newNative();
	public native void deleteNative();

	//konstruktor-destruktor
	ResourceRef(){ newNative(); }
	ResourceRef( int resID ){ this(); set( resID ); }
	ResourceRef( ResourceRef other ){ this(); set( other ); }
	public void finalize(){ deleteNative(); }

	public void release()
	{
		set( null );
	}

	public native void load();	//recursive load talajra
	public native void unload();

	//barmire:
	public native void cache();
	public native void precache();

	public native void destroy();

	public native void set( int ID );
	public native void set( ResourceRef ref );

	public native int type();
	public native int id();
	public native int getParentID();

	public native ResourceRef getParent();
	public native ResourceRef getFirstChild();
	public native ResourceRef getNextChild();
	public native ResourceRef getWTRoot();

	public native void makeTexture( ResourceRef parent, String filename );
	public native void makeSound( ResourceRef parent, String filename );

	//mesh resourceokra:
	public native void scaleMesh( float x, float y, float z );

	//mesh, renderobject resourceokra:
	public native void duplicate( ResourceRef src );


	public int countChildNodes()
	{
		int nodes;

		ResourceRef loop = getFirstChild();
		while( loop )
		{
			nodes++;
			loop=loop.getNextChild();
		}

		return nodes;
	}

	public ResourceRef[] getChildNodes()
	{
		int children = countChildNodes();
		if( children )
		{
			ResourceRef[] ar = new ResourceRef[children];

			int count;
			ResourceRef loop = getFirstChild();

			while( loop )
			{
				ar[count++]=loop;
				loop=loop.getNextChild();
			}

			return ar;
		}
		return null;
	}
}
