import system:util.resource.*;

public class RenderRef extends ResourceRef
{
	final static int RID_MENUBACK		= frontend:0x0000001Ar;
	final static int RID_MENULIGHT		= frontend:0x00000001r;

	public RenderRef(){ super(); }
	public RenderRef( ResourceRef parent, int rid, String alias ){ super(); create( parent, new RenderRef(rid), alias ); }
	public RenderRef( ResourceRef parent, RenderRef type, String alias ){ super(); create( parent, type, alias ); }

	public RenderRef( int id ){ super( id ); }
	public RenderRef( int prid, int rid, String alias ){ this( new ResourceRef(prid), rid, alias ); }

	public void create( ResourceRef parent, int rid, String alias ){ create( parent, new RenderRef(rid), alias); }
	public native void create( ResourceRef parent, RenderRef type, String alias );

	public native int  getBoneId( String alias );
	public native void setMatrix( int bone_id, ResourceRef bone_ref, Vector3 pos, Ypr ori );
	public native void setMatrix( Vector3 pos, Ypr ori );	//using root bone
	public void setMatrix( Pori r ){ setMatrix( r.pos, r.ori ); }

	public native Vector3 getPos();

	public native void changeResource( ResourceRef oldtexture, ResourceRef newtexture );
	public native void setColor( int color );
	public native void setLight( int diffuse, int ambient, int specular );
	public native void setFlare( ResourceRef glowtexture, int glowColor, float glowMinSize, float glowMaxSize, int flareCount, int rayCount );
	public native void setType( ResourceRef type );
	public native int  getTypeID();

	public native int  lineCreate( ResourceRef parent, ResourceRef type );
	public native void lineAdd( Vector3 pos, Vector3 normal, int color, float width );
	public native int  plotRoute( ResourceRef parent, ResourceRef type, int color, float step, Vector3 scale );
}


public class ParticleSystem extends RenderRef
{
	public ParticleSystem( ResourceRef parent, RenderRef type, String alias )
	{	
		super();	//create empty renderref structure
		init( parent, type, alias ); //fill
	}

	public ParticleSystem( ResourceRef parent, RenderRef type )
	{	
		this( parent, type, "particlesystem" ); 
	}

	public void finalize()
	{
		destroy();
	}

	public native void init( ResourceRef parent, RenderRef type, String alias );
	public native void	stop();
	public native void	setFreq( float freq );
	public native void	setDirectSource( String alias, Vector3 pos, float rmin, float rmax, Vector3 vel, float vmin, float vmax, float num, String bone );	
	public native void	setSource( String alias, Vector3 pos, float rmin, float rmax, Vector3 vel, float vmin, float vmax, float freq, String bone );
	public native void	setCounter( String alias, Vector3 pos, float r );
	public native int	getCounter( String alias );
	public native void	delAction( String alias );
	public native void	modePermanent( int permanent );
}

public class Welder extends RenderRef
{
	public Welder( ResourceRef parent, RenderRef type, String alias )
	{	
		super( parent, type, alias ); 
	}

	public Welder( ResourceRef parent, RenderRef type )
	{	
		super( parent, type, "welder" ); 
	}

	public void finalize()
	{
		destroy();
	}

	private native void addPoints( Vector3[] v, float width, Vector3 normal );
	public native int weld( Vector3 point, Vector3 line, float power );
	public native float progress();
}

public class Animation extends Native
{
	RenderRef	obj = new RenderRef();

	public native Animation( RenderRef object, ResourceRef anim );
	public native void finalize();

	public native void setSpeed( float speed );
	public native void setFade( float fade );

	public native void play();
	public native void loopPlay();
	public native void pause();

	public native void seek( float position );
	public native float getPos();

}