import system:util.resource.*;
import system:util.*;

public class GroundRef extends GameRef
{
	public native void setWater( float level, float density, float viscosity );
	public native void setWater( Vector3 point, Vector3 normal, float density, float viscosity );
	public native void addWaterLimit( Vector3 point, Vector3 normal );
	public native void setFog( int color, float near, float far );

	public int addTraffic( GameRef type, int n ){ return addTraffic( type, n, 1.0, 4.0, 2.0 ); }
	public int addTraffic( GameRef type, int n, float lenBegin, float lenEnd, float wheelBase  ){ return addTrafficN( type, n*Config.trafficDensity, lenBegin, lenEnd, wheelBase); }

	public native int addTrafficCar( GameRef instance, Vector3 pos );
	public native void remTrafficCar( int id );
	public native int notifyTrafficCar( int id, int state );
	public native int addTrafficN( GameRef type, int n, float lenBegin, float lenEnd, float wheelBase  );
	public native int addTrafficP( GameRef type, Vector3 pos, int n, float lenBegin, float lenEnd, float wheelBase  );
	public native void delTraffic();
	public native void setTrafficCarBehaviour( int id, int mode );
	public native void haltTrafficCross( Vector3 pos, float time );
	public native void haltTrafficPath( Vector3 p1, Vector3 p2 );

	public Vector3 getNearestCross( Vector3 approx ){ return getNearestCross( approx, 0.0 ); }
	public native Vector3 getNearestCross( Vector3 approx, float distance );
	public native Vector3 getStartDirection( Vector3 from, Vector3 to );
	public native float getRouteLength( Vector3 p1, Vector3 p2 );
	public native Vector3[] alignToRoad( Vector3 rp );

	 //fo/negyzetmeter
	public void setPedestrianDensity( float d ){ setPedestrianDensityN( d*Config.pedestrianDensity ); }
	public native void setPedestrianDensityN( float d );

	public native void addPedestrianType( GameRef g );
	public native void remPedestrianType( GameRef g );
	public native float pedestrianDistance( Vector3 pos, int typeID );
}