import system:util.resource.*;

public class GameRef extends ResourceRef
{
	//mirrored from "resourcenode.h"
	final static int WORLDTREEROOT = 0x00000010;
	final static int WORLDTREELEAF = 0x00000040;
	
	final static int RID_DUMMY			= system:0x001Br;

	final static int RID_FRONTEND		= system:0x0000002Fr;

//misc (native)
	final static int RID_CAMERA			= system:0x00000033r;
	final static int RID_TRIGGER		= system:0x00000034r;
	final static int RID_CURSOR			= frontend:0x0000002Ar;
	final static int RID_BUTTON			= frontend:0x00000024r;
	final static int RID_INVITEM		= frontend:0x0000002Br;

//finals mirrored from Game/Game.h
	final static int EVENT_COLLISION	= 0x00000001;
	final static int EVENT_DELETE		= 0x00000002;
	final static int EVENT_HIT			= 0x00000004;
	final static int EVENT_DAMAGE		= 0x00000008;
	final static int EVENT_COMMAND		= 0x00000010;
	final static int EVENT_TRIGGER_ON	= 0x00000020;
	final static int EVENT_TRIGGER_OFF	= 0x00000040;
	final static int EVENT_TIME			= 0x00000080;
	final static int EVENT_DESTROY		= 0x00000100;
	final static int EVENT_WATER		= 0x00000200;
	final static int EVENT_INFO			= 0x00000400;
	final static int EVENT_BODYCOLLISION= 0x00002000;
	final static int EVENT_GNDCOLLISION	= 0x00004000;
	final static int EVENT_NETEVENT		= 0x00008000;
	final static int EVENT_CURSOR		= 0x00010000;

	final static int EVENT_HOTKEY		= 0x00100000;

	final static int EVENT_ANY			= 0x0FFFFFFF;
	final static int EVENT_NONE			= 0x00000000;

	final static int EVENT_CUSTOMINFO	= 0x10000000;
	final static int EVENT_SAME			= 0;

	
//TRAFFIC CAR BEHAVIOR MODES
	final static int TC_ACTIVE			= 1;
	final static int TC_PASSIVE			= 2;

	public GameRef( GameRef ref ){ super( ref ); }
	public GameRef( GameRef parent, GameRef type, String params, String alias ){ super(); create( parent, type, params, alias ); }
	public GameRef( GameRef parent, int rid, String params, String alias ){ super(); create( parent, new GameRef(rid), params, alias ); }
	//felejteni kellene:	
	public GameRef( int id ){ super( id ); }
	public GameRef( int prid, int rid, String params, String alias ){ this( new GameRef(prid), rid, params, alias ); }

	public native GameType create( GameRef parent, GameRef type, String params, String alias );
	public native void create_native( GameRef parent, GameRef type, String params, String alias );

	
	public native int getFlags();
	public native void setFlags( int flags );
	public native void clearFlags( int flags );

	public native Ypr getOri();
	public native Vector3 getPos();
	public native Vector3 getVel();
	public native void setPos( Vector3 v );
	public native void setMatrix( Vector3 p, Ypr o );
	public native void setParent( ResourceRef newparent);
	public native void setState( Vector3 p, Ypr o, Vector3 l,Vector3 a );

	public native int isEmpty();									//ures gametype az illeto?
	public		  int isScripted(){ return isScripted( null ); }	//van-e scriptje a gametype/instancenek
	public native int isScripted( String clazzname );				//es az adott osztalynak ose-e
	public native Object getScriptInstance();						//itt a script peldany!

	public native int getInfo( int query, int subquery );
	public native int getInfo( int query, String subquery );
	public int getInfo( int query ){ return getInfo( query, 0 ); }

	public native void queueEvent( ResourceRef ro, int type, String param );
	void command( String param ) { queueEvent( null, EVENT_COMMAND, param); }

	public native void setActiveCollision();
}
