import system:util.*;
import system:util.resource.*;
import system:render.*;
import system:render.osd.*;

public class Sound
{
	public final static int MUSIC_SET_NONE = -1;
	public final static int MUSIC_SET_GARAGE = 0;
	public final static int MUSIC_SET_DRIVING = 1;
	public final static int MUSIC_SET_RACE = 2;
	public final static int MUSIC_SET_MENU = 3;

	public final static int CHANNEL_EFFECTS = 0;
	public final static int CHANNEL_MUSIC = 1;
	public final static int CHANNEL_ENGINE = 2;

	static native void changeMusicSet( int type );
	static native void nextTrack();
	static native void prevTrack();

	static void increaseVolume( int channel, float vol ){ float volume = getVolume( channel ) + vol; if( volume > 1.0 ) volume=1.0; setVolume( channel, volume ); }
	static void decreaseVolume( int channel, float vol ){ float volume = getVolume( channel ) - vol; if( volume < 0.0 ) volume=0.0; setVolume( channel, volume ); }

	static native void setVolume( int channel, float volume );
	static native float getVolume( int channel );

	static native int enableDebugDump( ResourceRef display );


	static	ResourceRef	debugDisplay;
	static	Viewport	vp;
	static	Camera		camera;

	public static void init()
	{
		Dummy display = new Dummy( Dummy.WORLDTREEROOT );
		if( Sound.enableDebugDump( display ) )
		{
			vp = new Viewport( 127, 0.0, 0.0, 1.0, 1.0 );
			camera = new Camera( display, vp, 0, 33.4, 0.1, 100.0 );
			camera.setMatrix( new Vector3(0.0, 0.0, 10.0),  null );
			vp.activate( Viewport.RENDERFLAG_CLEARDEPTH );	//start rendering
			debugDisplay = display;
		}
	}
}
