import system:util.*;
import system:io.*;

public class System extends Object
{
	public native static void exit();
	public native static void exit( String s );
	public native static void log( String s );
	public native static int buildNumber();

	public native static int gc();
	public native static int runFinalization();
	public native static int compileAll( String path );

	public native static void analyze( Object o );
	public native static void analyze( float f );
	public native static void analyze( int i );

	public native static void arraycopy(Object src, int src_position,
										Object dst, int dst_position, int length);
 
	public static native float currentTime();			//level 1 system time
	public static native float simTime();				//level 2 simulation time
	public static native float timeWarp( float m );		//set level 2 time speed

	public static native void syncGameTime( float t );	//level 3 game time; share it with the system
	public static native void setMeasure( float m );	//1000: km, 1600: mile
	public static native void getConfigOptions();

	public static native int netHost();
	public static native int netJoin();
	public static native int netLeave();

	public static native int openLib( String libName );

	public static native void isLoadingReset();
	public static native int isLoading();

	final static int LD_NORM = 0;
	final static int LD_HIGH = 1;

	public static native void setLdPriority( int pri );

	public static int rpkScan( String dir )
	{
		int	rpksfound;
		FindFile ff = new FindFile();
		String name=ff.first( dir + "*.rpk" );
		while( name )
		{
			rpksfound++;
			int	packID = System.openLib( dir + name );
			name = ff.next();
		}
		ff.close();

		return rpksfound;
	}

/*
	//----------------------------------------------------------------------language stuff
	Vector		thesauri;				//a regisztralt szotarak listaja
	String[]	preferred_languages;	//aktualis nyelvi beallitasok

    void register( Thesaurus d )
    {
		thesauri.addElement( d );
		if( preferred_languages )
			d.setLanguage( preferred_languages  );
    }
    void setLanguage( String s )
    {
		String[] tmp = new String[1];
		tmp[0]=s;
		setLanguage( tmp );
    }
    void setLanguage( String[] s )    
	{ 
		//store pref_lang, call setLanguage for each entry in the thesaurus vector 
	}

    static String[] getLanguageSelection()  {}
	//----------------------------------------------------------------------language stuff
*/
}
	
