import system:util.*;
import system:util.resource.*;

//mivel a gametypeok futasuk soran gyakran hivatkoznak onmagukra egy GameRef-fel,
//ezert szarmaztatjuk oket belole
//igy eleg csak egy this-t atadni a szukseges esetekben!

class GameType extends GameRef implements Runnable
{
	//finals mirrored from Game/GameInstance.h
	final static int GII_NULL			= 0;
	final static int GII_BONE			= 1;
	final static int GII_POS			= 2;
	final static int GII_VEL			= 3;
	final static int GII_DIR			= 4;
	final static int GII_ID				= 5;
	final static int GII_TYPE			= 6;
	final static int GII_CATEGORY		= 7;
	final static int GII_CONTROL		= 8;
	final static int GII_DRIVE			= 9;
	final static int GII_CONTROLLABLE	= 10;
	final static int GII_SIZE			= 11;
/*	final static int GII_MASS			= 12;
	final static int GII_VISIBLE		= 13;
	final static int GII_AUDIBLE		= 14;
*/	final static int GII_DAMAGE			= 15;
/*	final static int GII_FUEL			= 16;
	final static int GII_AMMO			= 17;
	final static int GII_OBJECT			= 18;
	final static int GII_MEDIA			= 19;
	final static int GII_ANIMAL			= 20;
	final static int GII_TEAM			= 21;
	final static int GII_TRIGGER		= 22;
*/	final static int GII_RENDERINSTANCE	= 23;
	final static int GII_OWNER			= 24;
	final static int GII_AXIS			= 25;
/*	final static int GII_OSD			= 26;
*/
	final static int GII_ANIMATE		= 28;

	final static int GII_CAMERA			= 34;

	final static int GII_INVITEM_CONTENTS	= 37;
	final static int GII_INVITEM_HOOK	= 38;

	final static int GII_GETOUT_OK		= 41;	//obsolete, kept only for compatibility
	final static int GII_REMOVE_OK		= 41;
	final static int GII_MODE			= 42;
	final static int GII_PART_OWNER		= 43;

//	final static int GII_PICKEDINSTANCE	= 44;
//	final static int GII_UV				= 45;

	final static int GII_RENDER			= 48;

	final static int GII_CAR_DRIVETYPE	= 52;

	final static int GII_PART_CATEGORY	= 55;
	final static int GII_CAR_TRAFFICPTR = 56;

	final static int GII_INSTALL_OK		= 71;
	final static int GII_COMPATIBLE		= 72;
	
	final static int GII_MAX			= 72;
	
	//mirrored from Game/GameInstance.h "enum GIR_CATEGORY"
	final static int GIR_CAT_VEHICLE		= 5;
	final static int GIR_CAT_PART			= 9;
	final static int GIR_CAT_BUTTON			= 10;
	final static int GIR_CAT_INVENTORYITEM	= 11;
	final static int GIR_CAT_BOLT			= 12;

//cursor events
	final static int EC_LDOWN			= 1;
	final static int EC_LUP				= 2;
	final static int EC_RDOWN			= 3;
	final static int EC_RUP				= 4;
	final static int EC_LCLICK			= 5;
	final static int EC_RCLICK			= 6;
	final static int EC_DBLCLICK		= 7;
	final static int EC_DBRCLICK		= 8;
	final static int EC_LDRAGBEGIN		= 9;
	final static int EC_LDRAGEND		= 10;
	final static int EC_LDROP			= 11;
	final static int EC_RDRAGBEGIN		= 12;
	final static int EC_RDRAGEND		= 13;
	final static int EC_RDROP			= 14;
	final static int EC_HOVER			= 15;
	final static int EC_LEAVE			= 16;


	public GameType(){}
	public GameType( int id ){ super( id ); }

	public void	finalize()
	{
		if( t )
			t.stop();

		destroy();			//gametype halalakor torli magat a resourcebol!
		super.finalize();	//a gameref pedig a resourceref-et!
	}


	//kiserleti threades stuff
	int	asyncMode;
	Thread t;
	MessagePort mp;

	//partial async msg handling msg (native msg's dont altered)
	public void enterAsyncMode_Script()
	{
		t = new Thread( this, toString() );

		mp = new MessagePort();
		t.start();
	}

	//muszaly igy inderekt modon megszuntetni, mert direkt hivas eseten is elvagjuk a szalat, aminek meg sok mas teendoje lenne... (pl exit utan a rakovetkezo enter meghivasa... )
	public void leaveAsyncMode_Script()
	{
		mp.putMessage( new Message( Message.MT_SYSTEM, Message.MC_SYS_TERMINATE ));
	}

	public void leaveAsyncMode_Script_Real()
	{
		t.stop();
		t = null;

		mp = null;
	}


	//total asyn message handling!
	public void enterAsyncMode()
	{
		asyncMode = 1;
		enterAsyncMode_Script();
	}
	public void leaveAsyncMode()
	{
		asyncMode = 0;
		leaveAsyncMode_Script();
	}

	public void handleEventAsync( GameRef obj_ref, int event, int param ){ mp.putMessage(); }
	public void handleEventAsync( GameRef obj_ref, int event, String param ){ mp.putMessage(); }
	public void run()
	{
		Message m;
		while(1)
		{
			mp.wait();
			while( m = mp.getMessage() )
			{
				if( m.type == Message.MT_SYSTEM && m.cmd == Message.MC_SYS_TERMINATE )
				{
					leaveAsyncMode_Script_Real();
					//nop - ide mar nem erhet el!
				}
				else
					if( m instanceof Event )
						handleMessage( (Event)m );
					else
						handleMessage( m );
			}
		}
	}
	public void handleMessage( Message m )
	{
	}


	public native void remNotification( GameRef ref, int etype );
	public native void addNotification( GameRef ref, int etype, int ealias, String custmsg );
	public native void addNotification( GameRef ref, int etype, int ealias, String custmsg, String custmethod );
	public native void addTimer( float deadline, int timerid );
	public native void removeAllTimers();

	public native void setEventMask( int eventmask );
	public native void clearEventMask( int eventmask );

	public native void registerCallback( int mode );
	public native void unregisterCallback( int mode );
	public native void unregisterCallbacks();	//unregister all callbacks


	public void enableControlHook(){ registerCallback(GII_CONTROL); }
	public void disableControlHook(){ unregisterCallback(GII_CONTROL); }
	public void enableAnimateHook(){ registerCallback(GII_ANIMATE); }
	public void disableAnimateHook(){ unregisterCallback(GII_ANIMATE); }

	//kell, hogy megallithasuk a vegtelen ciklusba kerulest
	public int getInfo( int query ){ return 0; }

	//new type gameinstances:
	public		  void createNativeInstance(){ createNativeInstance( null, 0, null, null ); }
	public		  void createNativeInstance( GameRef parent ){ createNativeInstance( parent, 0, null, null ); }
	public native void createNativeInstance( GameRef parent, int typeID, String params, String alias );

	//empty default methods:
	public void handleEvent( GameRef obj_ref, int event, int param ){}
	public void handleEvent( GameRef obj_ref, int event, String param ){}
	public void control(float t){}
	public void drive(){}
	public void animate(){}
}
