import system:io.*;

import system:util.*;
import system:util.resource.*;
import system:render.*;
import system:render.osd.*;

public class Input
{
	//finals mirrored from CInput.h, 'VIRTUAL_AXIS'
	final static int	AXIS_NULL				= 0;

	// rotational DOFs
	final static int	AXIS_TURN_LEFTRIGHT		= 1;	//yaw
	final static int	AXIS_TURN_UPDOWN		= 2;	//pitch
	final static int	AXIS_TURN_CCWCW			= 3;	//roll

	// linear DOFs
	final static int	AXIS_MOVE_LEFTRIGHT		= 4;	//x
	final static int	AXIS_MOVE_UPDOWN		= 5;	//y
	final static int	AXIS_MOVE_FWDBACK		= 6;	//z

	// camera (head) control
	final static int	AXIS_LOOK_LEFTRIGHT		= 7;	//yaw
	final static int	AXIS_LOOK_UPDOWN		= 8;	//pitch
	final static int	AXIS_LOOK_CCWCW			= 9;	//roll
	final static int	AXIS_LOOK_FWDBACK		= 10;	//near/far

	final static int	AXIS_LOOK_ZOOM			= 11;
	final static int	AXIS_LOOK_PREVNEXT		= 12;	// change camera
	final static int	AXIS_LOOK_REAR			= 13;	// rearview

	//menu control
	final static int	AXIS_MENU_LEFTRIGHT		= 14;
	final static int	AXIS_MENU_UPDOWN		= 15;
	final static int	AXIS_MENU_PREVNEXT		= 16;
	// actions
	final static int	AXIS_FIRE_PRI			= 17;	// fire 'weapon 1' (primary)
	final static int	AXIS_FIRE_SEC			= 18;	// fire 'weapon 2' (secondary)
	final static int	AXIS_USE				= 19;	// other action, use item, etc

	// cycle primary 'weapon'
	final static int	AXIS_PRI_PREVNEXT		= 20;
	// cycle secondary 'weapon'
	final static int	AXIS_SEC_PREVNEXT		= 21;

	// cycle target
	final static int	AXIS_TARGET_PREVNEXT	= 22;
	final static int	AXIS_TARGET_LEFTRIGHT	= 23;
	final static int	AXIS_TARGET_UPDOWN		= 24;

	// cycle control (mode or instance)
	final static int	AXIS_CONTROL_PREVNEXT	= 25;
	final static int	AXIS_CONTROL_LEFTRIGHT	= 26;
	final static int	AXIS_CONTROL_UPDOWN		= 27;

	// specific vehicle control
	final static int	AXIS_THROTTLE			= 28;
	final static int	AXIS_BRAKE				= 29;
	final static int	AXIS_SHIFT_UPDOWN		= 30;
	final static int	AXIS_NITRO				= 31;	// turbo, boost, etc

	// menu selection
	final static int	AXIS_START				= 32;
	final static int	AXIS_PAUSE				= 33;
	final static int	AXIS_SELECT				= 34;
	final static int	AXIS_CANCEL				= 35;
	final static int	AXIS_MENU				= 36;
	final static int	AXIS_MAP				= 37;
	final static int	AXIS_HELP				= 38;

	final static int	AXIS_CHEAT_1			= 39;
	final static int	AXIS_CHEAT_2			= 40;

	final static int	AXIS_SHIFT_LOOK			= 41;		//changes between cursor movement / camera rotation

//mouse control
	final static int	AXIS_CURSOR_X			= 42;
	final static int	AXIS_CURSOR_Y			= 43;
	final static int	AXIS_CURSOR_Z			= 44;

	final static int	AXIS_CURSOR_BUTTON1		= 45;
	final static int	AXIS_CURSOR_BUTTON2		= 46;
	final static int	AXIS_CURSOR_BUTTON3		= 47;

	final static int	AXIS_HANDBRAKE			= 48;
	final static int	AXIS_CLUTCH				= 49;			//kuplung
	final static int	AXIS_GEAR_UPDOWN		= 50;
	final static int	AXIS_GEAR_SET			= 51;

	final static int	AXIS_MUSIC_VOLUME		= 52;
	final static int	AXIS_MUSIC_SELECT		= 53;

	final static int	AXIS_HORN				= 54;

	final static int	AXIS_MENU_UP			= 55;
	final static int	AXIS_MENU_DOWN			= 56;
	final static int	AXIS_MENU_LEFT			= 57;
	final static int	AXIS_MENU_RIGHT			= 58;
	final static int	AXIS_MUSIC_VOLUME_UP	= 59;
	final static int	AXIS_MUSIC_VOLUME_DOWN	= 60;
	final static int	AXIS_MUSIC_SELECT_NEXT	= 61;
	final static int	AXIS_MUSIC_SELECT_PREV	= 62;

	final static int	AXIS_PRINTSCREEN		= 63;

	final static int	AXIS_SPECIAL_1			= 68;
	final static int	AXIS_SPECIAL_2			= 69;
	final static int	AXIS_SPECIAL_3			= 70;
	final static int	AXIS_SPECIAL_4			= 71;
	final static int	AXIS_SPECIAL_5			= 72;
	final static int	AXIS_SPECIAL_6			= 73;
	final static int	AXIS_SPECIAL_7			= 74;
	final static int	AXIS_SPECIAL_8			= 75;

	//finals mirrored from RControl.h
	final static int	RCDIK_ESCAPE		= 0x01;
	final static int	RCDIK_1				= 0x02;
	final static int	RCDIK_2				= 0x03;
	final static int	RCDIK_3				= 0x04;
	final static int	RCDIK_4				= 0x05;
	final static int	RCDIK_5				= 0x06;
	final static int	RCDIK_6				= 0x07;
	final static int	RCDIK_7				= 0x08;
	final static int	RCDIK_8				= 0x09;
	final static int	RCDIK_9				= 0x0A;
	final static int	RCDIK_0				= 0x0B;

	final static int	RCDIK_BACK			= 0x0e;
	final static int	RCDIK_TAB			= 0x0f;
	final static int	RCDIK_Q				= 0x10;
	final static int	RCDIK_W				= 0x11;
	final static int	RCDIK_E				= 0x12;
	final static int	RCDIK_R				= 0x13;
	final static int	RCDIK_T				= 0x14;
	final static int	RCDIK_Y				= 0x15;
	final static int	RCDIK_U				= 0x16;
	final static int	RCDIK_I				= 0x17;
	final static int	RCDIK_O				= 0x18;
	final static int	RCDIK_P				= 0x19;

	final static int	RCDIK_ENTER			= 0x1c;

	final static int	RCDIK_A				= 0x1e;
	final static int	RCDIK_S				= 0x1f;
	final static int	RCDIK_D				= 0x20;
	final static int	RCDIK_F				= 0x21;
	final static int	RCDIK_G				= 0x22;
	final static int	RCDIK_H				= 0x23;
	final static int	RCDIK_J				= 0x24;
	final static int	RCDIK_K				= 0x25;
	final static int	RCDIK_L				= 0x26;

	final static int	RCDIK_Z				= 0x2c;
	final static int	RCDIK_X				= 0x2d;
	final static int	RCDIK_C				= 0x2e;
	final static int	RCDIK_V				= 0x2f;
	final static int	RCDIK_B				= 0x30;
	final static int	RCDIK_N				= 0x31;
	final static int	RCDIK_M				= 0x32;

	final static int	RCDIK_SPACE			= 0x39;

	final static int	RCDIK_F1			= 0x3b;
	final static int	RCDIK_F2			= 0x3c;
	final static int	RCDIK_F3			= 0x3d;
	final static int	RCDIK_F4			= 0x3e;
	final static int	RCDIK_F5			= 0x3f;
	final static int	RCDIK_F6			= 0x40;
	final static int	RCDIK_F7			= 0x41;
	final static int	RCDIK_F8			= 0x42;
	final static int	RCDIK_F9			= 0x43;
	final static int	RCDIK_F10			= 0x44;
	final static int	RCDIK_F11			= 0x57;
	final static int	RCDIK_F12			= 0x58;

	final static int	RCDIK_UP			= 0xc8;
	final static int	RCDIK_LEFT			= 0xcb;
	final static int	RCDIK_RIGHT			= 0xcd;
	final static int	RCDIK_DOWN			= 0xd0;

	final static int	RCDIK_COMMA			= 0x33;
	final static int	RCDIK_PERIOD		= 0x34;

	final static int	RCDIK_NUMLOCK		= 0x45;
	final static int	RCDIK_NUMPADSLASH	= 0xb5;
	final static int	RCDIK_NUMPADSTAR	= 0x37;
	final static int	RCDIK_NUMPADMINUS	= 0x4a;
	final static int	RCDIK_NUMPADPLUS	= 0x4e;
	final static int	RCDIK_NUMPADENTER	= 0x9c;
	final static int	RCDIK_NUMPADDECIMAL	= 0x53;

	final static int	RCDIK_NUMPAD0		= 0x52;
	final static int	RCDIK_NUMPAD1		= 0x4f;
	final static int	RCDIK_NUMPAD2		= 0x50;
	final static int	RCDIK_NUMPAD3		= 0x51;
	final static int	RCDIK_NUMPAD4		= 0x4b;
	final static int	RCDIK_NUMPAD5		= 0x4c;
	final static int	RCDIK_NUMPAD6		= 0x4d;
	final static int	RCDIK_NUMPAD7		= 0x47;
	final static int	RCDIK_NUMPAD8		= 0x48;
	final static int	RCDIK_NUMPAD9		= 0x49;


	final static int	RCDIK_PGUP			= 0xc9;
	final static int	RCDIK_PGDN			= 0xd1;

	final static int		MAXPLAYERS			= 1;

	static	Controller[]	controllers = new Controller[MAXPLAYERS];
	static	float[]			player_input = new float[MAXPLAYERS];

	public static MouseCursor		cursor;

	public native static float getAxis( int device, int axis );
	public native static String getDeviceName( int i );
	public native static void mapAxis ( GameRef inst, int l_axis, int device, int i_axis,	float i_from, float i_to, float l_from, float l_to );
	public native static void setAxisSmooth ( GameRef inst, int l_axis, float a, float b, float c, float d );
	public native static int activeAxis( int device );
	public native static String axisName( int device, int axis );
	public native static int lastKey();

	public native static void createHotkey( int axis, int flags, Hotkey hk, GameRef handler, Osd owner, int eventFilter );
	public native static void deleteHotkey( Hotkey hk );
	public native static void checkHotkeys( GameRef inst, Osd infocus );
	public native static void flushHotkeys();	//"porgesmentesites"

	final static int VIRTUAL = 1;
	final static int KEY = 2;

	public static Hotkey createGlobalHotkey( int axis, int flags, Hotkey h, GameRef handler )
	{
		return createHotkey( axis, flags, h, handler, null, Event.F_KEY_PRESS );
	}

	public static void flushKeys()
	{
		while( lastKey() )
			;

		flushHotkeys();
	}

	public static void initControllers( GameRef parentNode, String fileName )
	{
		Controller.controlFile = fileName;

		String	name;
		int[]	tmp = new int[MAXPLAYERS];	//expect no more controllers.. :0
		int		i=0,j;

		int	old_controls = 0;

		if (old_controls)
		{
			//filter out unsupported input devices
			while( i < tmp.length && ((name = getDeviceName( i )) != null)  )
			{
				if( name != "SysMouse" )
				//if( name != "SysKeyboard" )
				{
					Controller controller = new Controller( parentNode, "0 0 " + j );
					controller.queueEvent( null, GameType.EVENT_COMMAND, "device " + i );

					addController( controller );

					j++;
				}
				++i;
			}
		}
		else
		{
			//create only ONE controller
			Controller controller = new Controller( parentNode, "0 0 " + j );
			addController( controller );

			controller.queueEvent( null, GameType.EVENT_COMMAND, "setcontrol" );
		}

	}

	//controllers that succesfully created by init, or by network, call this method
	public static void addController( Controller c )
	{
		for( int i=0; i<controllers.length; i++ )
		{
			if( !isPlayerActive( i ) )
			{
				controllers[i] = c;
				break;
			}
		}
	}

	public static int getActivePlayers()
	{
		int j,i = controllers.length;
		while( i )
			if( isPlayerActive( --i ) )
				j++;

		return j;
	}

	public static int isPlayerActive( int n )
	{
		if( controllers.length > n )
			if( controllers[n] )
				if( controllers[n].id() )
					return 1;
		return 0;
	}

	public static void destroyControllers()
	{
		int i=controllers.length;
		while( i )
			if( controllers[--i] )
			{
				controllers[i].destroy();	//=null?
			}
	}

	public static int getInput( int axis_id )
	{
		return getInput( axis_id, -1 );
	}

	public static int getInput( int axis_id, int player )
	{
		int	result;

		int	loop;

		if (player >= 0)
		{
			if( isPlayerActive(player) )
			{
				result = controllers[player].getInfo( GameType.GII_AXIS, axis_id );

				if( result )
					player_input[player]=System.currentTime();
			}
		} 
		else	//any input acceptable
		{
			int res;
			loop = MAXPLAYERS;

			while( loop )
			{
				--loop;
				if( isPlayerActive(loop) )
				{
					res = controllers[loop].getInfo( GameType.GII_AXIS, axis_id );

					if( res )
						player_input[loop]=System.currentTime();

					result += res; 
				}
			}
		}
		return result;
	}


	//meg kellene teremteni a lehetoseget, hogy tobb is lehessen
	//pl: MouseCursor mc = addPointingDevice(); //->listaban tarolna
	//    remPointingDevice( MouseCursor mc );
	//...igeny szerint

	public static void enablePointingDevice()
	{
		cursor = new MouseCursor();
	}

	public static void disablePointingDevice()
	{
		cursor = null;
	}
}

//--------------------------------------------------------------------------------------------

public class MouseCursor extends GameType
{
	GameRef         cursor;
	Viewport		vp;
	Camera			camera;
	String			pointer;
	int				visible;

	Controller		controller;		//the controller that controls the mouse..khm when moving a camera!
	GameRef			controlledcam;	//the controlled camera (while pressing right button)

	public MouseCursor()
	{
		createNativeInstance();
		setFlags( WORLDTREEROOT );

		//lehetne az alabbi gametypenak a scriptje...
		cursor = new GameRef( this, GameRef.RID_CURSOR, "0,0,0", "Mouse cursor" );
		vp = new Viewport( 127, 0.0, 0.0, 1.0, 1.0 );

		camera = new Camera( this, vp, 0, 33.4, 0.1, 100.0 );
		camera.setMatrix( new Vector3(0.0, 0.0, 10.0),  null );

		cursor.queueEvent( null, GameType.EVENT_COMMAND, "cursor "+vp.id()+" "+camera.id()+" "+cursor.id() );
		cursor.queueEvent( null, GameType.EVENT_COMMAND, "move 0, 0.2" );
		
		setPointer( Frontend.pointers, "J");
	}

	public void finalize()
	{
		camera.destroy();
		vp.destroy();
		cursor.destroy();

		super.finalize();
	}

	public int enable( int state )
	{
		int	prevState = visible;

		if( visible ^ state)
		{
			if( state )
			{	//bekapcs
				vp.activate( Viewport.RENDERFLAG_CLEARDEPTH );	//start rendering
				cursor.queueEvent( null, GameType.EVENT_COMMAND, "enable");	//enable collision test
				cursor.queueEvent( null, GameType.EVENT_COMMAND, "activate "+controller.id() );
			}
			else
			{	//kikapcs
				cursor.queueEvent( null, GameType.EVENT_COMMAND, "disable");//disable collision test
				vp.deactivate();										//stop rendering
				cleanup();
			}
			visible = state;
		}

		return prevState;
	}

	//force reread sensitivity (from Config.mouseSensitivity)
	public void config()
	{
		cursor.queueEvent( null, GameType.EVENT_COMMAND, "sens");
	}

	//change pointer look
	public void setPointer( ResourceRef charset, String singlechar )
	{
		pointer = singlechar;
		cursor.queueEvent( null, GameType.EVENT_COMMAND, "mode 0 " + pointer + " " + charset.id() );
	}

	public void setController( Controller ctrl )
	{
		controller=ctrl;
	}

	//ezt igazabol a kameraba kellene tenni, de sajnos nem minden kamera sriptelt
	//(van egy scriptes, meg egy nativ tipus)

	public void enableCameraControl( GameRef cam  )
	{
		if( cam )
		{
			if ( controller )
			{
				if( controlledcam )
					enableCameraControl( null );
		
				controlledcam = cam;
				controller.queueEvent( null, GameType.EVENT_COMMAND, "camera " + cam.id() );
				cursor.queueEvent( null, GameType.EVENT_COMMAND, "activate "+controller.id()+" "+cam.id() );
				//controller.activateState( ControlSet.CAMTURN );
			}
		}
		else
		{
			disableCameraControl();
		}

	}

	public void disableCameraControl()
	{
		//cut it off the player
		if( controlledcam )
		{
			controlledcam.queueEvent( null, GameType.EVENT_COMMAND, "deactivate" );
			controlledcam=null;
			//controller.deactivateState( ControlSet.CAMTURN );
		}
	}
	//------------------------------------------------------------------------------------


	//alakitsu at sciptes message systemre! (foleg ha majd gyors lesz a SE)
	public void addHandler( GameType handler )
	{
		handler.addNotification( cursor, GameType.EVENT_CURSOR, GameType.EVENT_SAME, null );
	}

	public void remHandler( GameType handler )
	{
		handler.remNotification( cursor, GameType.EVENT_CURSOR );
	}

	void cleanup()
	{//delete particlesystems to avoid _long_ sparks

		ResourceRef[] ct = this.getChildNodes();

		for( int i=ct.length-1; i>=0; i-- )
		{
			if (ct[i].type() == ResourceRef.INSTANCE_RENDER)
			{
				RenderRef ri = (RenderRef)(ct[i]);
				if (ri.getTypeID() == particles:0x0024r)
					ri.destroy();
			}

		}

	}

	public native Vector3 getPos();
	public native Vector3 getPickedPos();
}



