import system:io.*;

import system:util.*;
import system:render.*;
import system:render.osd.*;


class Hotkey
{
	int		key;
	int		flags;
	int		command;
	GameRef	handler;
	Osd		osd;
	int		eventFilter=Event.F_KEY_PRESS;
	int		state;

	//for system global keys
	//inactivate must be explicitly called for these!!!
	public Hotkey( int k, int f, int c, GameRef h )
	{
		key = k;
		flags = f;
		command = c;
		handler = h;

		Input.createGlobalHotkey( key, flags, this, handler );
	}

	//for osd keys
	public Hotkey( int k, int f, int c, GameRef h, Osd o, int ef )
	{
		key = k;
		flags = f;
		command = c;
		handler = h;
		osd = o;
		eventFilter = ef;
	}

	public void activate()
	{
		Input.createHotkey( key, flags, this, osd, osd, eventFilter );
	}

	public void inactivate()
	{
		Input.deleteHotkey( this );
	}

//There should be an other way to check this!
//	public void finalize()
//	{
//		if( nativeID )
//			System.log( "finalizing uninitalized Hotkey" );
//	}

}
