import system:io.*;

import system:util.resource.*;
import system:util.*;

public class Controller extends GameType
{
	final static int RESOURCEID	= system:0x00000032r;

	//name and path of the default (active) control file
	static String	controlFile;

	String			name;
	ControlSetState	css;

	public Controller( GameRef parentNode, String params )
	{
		createNativeInstance( parentNode, RESOURCEID, params, "controller" );
		css = new ControlSetState();
	}

	public void add( ControlSet cs, int i )
	{
		float from_min = cs.from_min[i] + (cs.from_max[i] - cs.from_min[i]) * cs.dead_zone[i];
		user_Add( cs.vaxisID[i], cs.deviceID[i], cs.axisID[i], from_min, cs.from_max[i], cs.to_min[i], cs.to_max[i] );
	}

	public void del( ControlSet cs, int i )
	{
		user_Del( cs.vaxisID[i], cs.deviceID[i], cs.axisID[i] );
	}

	public void smooth( VirtualAxisSmoothProperties vasp )
	{
		user_SetAxisSmooth ( vasp.vAxisID, vasp.center_range, vasp.factor_center, vasp.factor_opposite, vasp.factor_same, vasp.power );
	}
	
	//setcontrol: a regi modszer a kontrolbeallitasra - control menuk meg ezt hasznaljak!
	public void setcontrol( ControlSet cs )
	{
		user_Reset();

		for (int i = 0; i < cs.nitems(); i++)
		{
			add( cs, i );
		}

		for (int i = 0; i < cs.vasp.size(); i++)
		{
			smooth( cs.vasp.elementAt(i) );
		}

		if( Config.majomParade )
		{
			user_Add( Input.AXIS_CHEAT_1,	0, Input.RCDIK_F7,	0.0f, 1.0f, 0.0f, 1.0f);
			user_Add( Input.AXIS_CHEAT_2,	0, Input.RCDIK_F8,	0.0f, 1.0f, 0.0f, 1.0f);
		}
	}

	public void setcontrol()
	{
		ControlSet cs = new ControlSet();

		cs.load( controlFile );
		setcontrol( cs );
	}

	//ControlSetState-es uj modszer!
	public ControlSetState reset( ControlSetState newcss )
	{
		ControlSetState	oldcss;

		oldcss = css;

		css = new ControlSetState();

		user_Reset();

		if( newcss != null )
		{
			for( int i = 0; i < newcss.NGROUPS; i++ )
			{
				if( newcss.get( i ) == 1)
				{
					activateState( i, 1 );
				}
			}
		}
		else
		{
			activateState( ControlSet.DEFAULTSET );
		}

		if( Config.majomParade )
		{
			user_Add( Input.AXIS_CHEAT_1,	0, Input.RCDIK_F7,	0.0f, 1.0f, 0.0f, 1.0f);
			user_Add( Input.AXIS_CHEAT_2,	0, Input.RCDIK_F8,	0.0f, 1.0f, 0.0f, 1.0f);
		}

		return( oldcss );
	}

	public ControlSetState reset()
	{
		return( reset( null ) );
	}

	public void activateState( int group, int new_state )
	{
		if( css.get( group ) == new_state )
		{
			return;
		}

		css.set( group, new_state );

		ControlSet cs = new ControlSet();

		cs.load( controlFile );

		for (int i = 0; i < cs.nitems(); i++)
		{
			if( cs.group[i] == group)
			{
				if( new_state == 1 )
				{
					add( cs, i );
				}
				else
				{
					del( cs, i );
				}
			}
		}

		//smooth settings are global:
		for (int i = 0; i < cs.vasp.size(); i++)
		{
			smooth( cs.vasp.elementAt(i) );
		}

	}

	public void activateState( int group )
	{
		activateState( group, 1 );
	}

	public native int user_Add( int vaxis, int device, int paxis, float a, float b, float c, float d );
	public native int user_Del( int vaxis, int device, int paxis );
	public native int user_SetAxisSmooth( int vaxis, float a, float b, float c, float d, float e );
	public native void user_SetAxisSpeed( int vaxis, float a );
	public native float user_GetAxisVal( int vaxis );
	public native void user_SetAxisForce( int vaxis, float c, float f );
	public native void user_Reset();
}

public class controlconfig extends Controller
{
	String	name;
}

public class ControlSetState
{
	final static int	NGROUPS = 5;

	int[]				state;

	public ControlSetState()
	{
		state = new int[NGROUPS];
		reset();
	}

	public void reset()
	{
		for( int i = 0; i < NGROUPS; i++ )
		{
			set( i, 0 );
		}
	}

	public void set( int i, int value )
	{
		if( i >= 0 && i < NGROUPS )
		{
			state[i] = value;
		}
	}

	public int get( int i )
	{
		if( i >= 0 && i < NGROUPS )
		{
			return( state[i] );
		}

		return( 0 );
	}
}

