package java.game;

import java.io.*;
import java.util.*;
import java.util.resource.*;
import java.render.*;	//Text
import java.render.osd.*;	//Text
import java.sound.*;


abstract public class Track extends Scene implements GameState
{
	final static int RID_CHEVYVAN = cars.traffic.chevy_van:0x00000005r;

	//ezeket a leszarmazott allitsa be!
	abstract Vector3	posStart;
	abstract Ypr		oriStart;

	//hold the id of the currently active trigger (shop, garage, etc)
	int				activeTrigger;
	Vector			trigger = new Vector();

	GameState		parentState;

	Osd				osd;
	int				osdCounter;

	IngameMenu		ingameMenu;
	int				im_active;

	int				camRotate;

	int				killCar;

	final static int CMD_CHANGECAM_TV = 0;
	final static int CMD_INGAMEMENU = 1;
	final static int CMD_MECHANIC = 2;
	final static int CMD_CAMMOVE = 3;
	final static int CMD_OPPCAM = 4;
	final static int CMD_PAINT = 5;
	final static int CMD_OSDONOFF = 6;
	final static int CMD_CHANGECAM_INT = 7;
	final static int CMD_CHANGECAM_EXT = 8;
	final static int CMD_CRUISECONTROL = 9;
	final static int CMD_CHANGECAM_CHASE = 10;
	final static int CMD_CHANGECAM_INVCH = 11;
	final static int CMD_CHANGECAM_FREE = 12;
	final static int CMD_SIMSPEEDINC = 13;
	final static int CMD_SIMSPEEDDEC = 14;
	final static int CMD_SIMPAUSE = 15;
	final static int CMD_CAMROTATE = 16;
	final static int CMD_QUICKREPAIR = 17;
	final static int CMD_CHANGECAMTARGET = 18;
	final static int CMD_EXIT = 19;

	Navigator		nav;
	Marker			mPlayer;

	Player			player;
	GameRef			cursor;

	//message display
	Text			messages;
	Text			infoline;
	int				msgtimers;
	int				osdEnabled;

	//cam
	GameRef			cam_external;	//external camera instance
	GameRef			cam;			//currently active camera instance
	GameRef			renderer;
	GameRef			cameraTarget;	//car of the player (usually) or another bot
	GameRef			cameraTarget2;	//another car or object (police, racer, etc.)
	int				cameraMode;
	int				cameraNum;		//ha pl. tobb camera van az adott cameraMode-hoz (pl. belso, de lehet TV, ext, stb. is)

	Vector3			lastCamPos;
	Vector3			lastCrossPos;	//for TV-camera
	
	Viewport		vport2;

	final static int CAMMODE_NONE = 0;
	final static int CAMMODE_FOLLOW = 1;
	final static int CAMMODE_TV = 2;
	final static int CAMMODE_CHASE = 3;
	final static int CAMMODE_INVCH = 4;
	final static int CAMMODE_INTERNAL = 5;
	final static int CAMMODE_FREE = 6;
	final static int CAMMODE_POINT = 7;

	Mechanic mechanic;
	Painter painter;
	int		mc_active, pt_active;

	public Track()
	{
		createNativeInstance();

		player=GameLogic.player;
	}


	public void animate()
	{
		if( nav && player.car )
		{
			nav.updateNavigator( player.car );
		}
	}

//----------------------------------------------------------------------

	public void enter( GameState prev_state )
	{
		if( prev_state instanceof RaceSetup )
		{
		}
		else
		{
//			cameraMode = CAMMODE_FOLLOW;	//reset

			enterAsyncMode_Script();
			t.setPriority( Thread.MAX_PRIORITY );

			//test:
			GameLogic.autoSaveQuiet();
	
			//a gyerekosztalyok implementaljak a kov ket sort, az o enter() metodusukban!
			//Frontend.loadingScreen.show();
			//GfxEngine.flush();

			parentState=prev_state;

			osd = new Osd();
			osd.menuKeysCreated = 1;
//			osd.iLevel=Osd.IL_KEYS;
			osd.alienMp = mp;

			//only for ects/intel demo
			//osd.createRectangle( 0.70, -0.80, 0.5, 0.4, -1, new ResourceRef(frontend:0x00AAr) );


			//---------------------------------time of day dependent stuff:
			addSceneElements( GameLogic.getTime() );
			//-----------------------------------------------------------------------

			msgtimers=0;
			messages=osd.createText( null, Frontend.largeFont, Text.ALIGN_CENTER, 0.0, -0.5 );

			setEventMask( EVENT_CURSOR|EVENT_COMMAND|EVENT_HOTKEY|EVENT_TRIGGER_ON|EVENT_TRIGGER_OFF|EVENT_TIME );

			//player
			player.render = new RenderRef( map, player.driverID, "player" );
			player.controller.command( "renderinstance " + player.render.id() );

			if (player.car)
			{
				if( GameLogic.gameMode != GameLogic.GM_DEMO )
				{
					lockCar();
					player.car.command( "setsteer 0" );

					//igy ha valtoztak a config beallitasok, az is szamit neki!
					player.car.setDefaultTransmission();
					player.car.setDefaultSteeringHelp();
					player.controller.command( "controllable " + player.car.id() );
				}

				lastCamPos = new Vector3( 0, 3, 6);
				lastCamPos.add( player.car.getPos() );
				changeCamTarget(player.car);
				changeCamFollow();// cameraPos );

				map.command( "obs_add " + player.car.id() );
			}

			ingameMenu=new IngameMenu( this );

			infoline=osd.createText( null, Frontend.mediumFont, Text.ALIGN_RIGHT, 0.97, 0.57);

			osd.endGroup();

			//painter =  new Painter( player, osd, null, infoline, 1 );
			//mechanic = new Mechanic( player, osd, null, infoline, 1 );

			if( Config.majomParade )
			{
				osd.createHotkey( Input.RCDIK_NUMPADDECIMAL, Input.KEY|Osd.HK_STATIC, CMD_OSDONOFF, this );
				osd.createHotkey( Input.RCDIK_1, Input.KEY|Osd.HK_STATIC, CMD_SIMSPEEDDEC, this );
				osd.createHotkey( Input.RCDIK_2, Input.KEY|Osd.HK_STATIC, CMD_SIMSPEEDINC, this );
				osd.createHotkey( Input.RCDIK_3, Input.KEY|Osd.HK_STATIC, CMD_SIMPAUSE, this );
				osd.createHotkey( Input.RCDIK_4, Input.KEY|Osd.HK_STATIC, CMD_CAMROTATE, this );
			}

			osd.createHotkey( Input.RCDIK_F1, Input.KEY|Osd.HK_STATIC, CMD_CHANGECAM_INT, this );
			osd.createHotkey( Input.RCDIK_F2, Input.KEY|Osd.HK_STATIC, CMD_CHANGECAM_TV, this );
			osd.createHotkey( Input.RCDIK_F3, Input.KEY|Osd.HK_STATIC, CMD_CHANGECAM_EXT, this );
			osd.createHotkey( Input.RCDIK_F4, Input.KEY|Osd.HK_STATIC, CMD_CHANGECAM_CHASE, this );
			osd.createHotkey( Input.RCDIK_F5, Input.KEY|Osd.HK_STATIC, CMD_CHANGECAM_INVCH, this );
//debug:
			if( Config.majomParade )
			{
				osd.createHotkey( Input.RCDIK_F9, Input.KEY|Osd.HK_STATIC, CMD_CHANGECAM_FREE, this );
				osd.createHotkey( Input.RCDIK_F10, Input.KEY|Osd.HK_STATIC, CMD_QUICKREPAIR, this );
				osd.createHotkey( Input.RCDIK_F11, Input.KEY|Osd.HK_STATIC, CMD_CHANGECAMTARGET, this );
			}

			osd.createHotkey( Input.RCDIK_S, Input.KEY|Osd.HK_STATIC, CMD_CRUISECONTROL, this );
			osd.createHotkey( Input.AXIS_MENU, Input.VIRTUAL|Osd.HK_STATIC, CMD_INGAMEMENU, this );
			osd.createHotkey( Input.AXIS_CURSOR_BUTTON2, Input.VIRTUAL|Osd.HK_STATIC, CMD_CAMMOVE, Event.F_KEY_PRESS|Event.F_KEY_RELEASE );

			osd.show();	//kulonfele messageknek, hotkeyeknek kell

			osdEnabled = 1;
			enableOsd( osdEnabled );	//player osd, navigator

			if( nav )
			{
				mPlayer = nav.addMarker( player );
			}

			
			Sound.changeMusicSet( Sound.MUSIC_SET_DRIVING );

			// special request: reset mouse and set sensitivity
			Input.getAxis (1, -1 - (Config.mouseSensitivity * 100.0f));

			addTimer( 1, 2 );	//one sec tick starter

//start automatic camerachanges
			if (1)
			if( GameLogic.gameMode == GameLogic.GM_DEMO )
				addTimer (5, 4 );
		}

		new ResourceRef( particles:0x0106r ).cache(); //def spark
		new ResourceRef( particles:0x0002r ).cache(); //def smoke
		new ResourceRef( particles:0x000Ar ).cache(); //def skidmark

		new SfxRef( sound:0x000Br ).cache(); //def collision
		new SfxRef( sound:0x0006r ).cache(); //def skid
		new SfxRef( sound:0x0015r ).cache(); //def horn
		new SfxRef( sound:0x000Ar ).cache(); //def ignition
		new SfxRef( sound:0x0017r ).cache(); //def gear up
		new SfxRef( sound:0x0018r ).cache(); //def gear down
		new SfxRef( sound:0x001Ar ).precache(); //def air
		new SfxRef( sound:0x000Dr ).precache(); //tyre out

		if( GameLogic.gameMode == GameLogic.GM_QUICKRACE && !(prev_state instanceof RaceSetup) )
		{
		}
		else
		{
			Frontend.loadingScreen.display();	//waits! -------------------------------------
		}

		player.controller.reset();
		player.controller.activateState( ControlSet.DRIVERSET );

		enableAnimateHook();
	}

	public void exit( GameState next_state )
	{
		disableAnimateHook();

		if( next_state instanceof RaceSetup )
		{
		}
		else
		{	
			removeAllTimers();
			trigger.removeAllElements();

			changeCamNone();

			if (player.car)
			{
				map.command( "obs_rem " + player.car.id() );

				posStart = player.car.getPos();
				oriStart = player.car.getOri();
				player.controller.command( "leave " + player.car.id() );
			}

			player.render.destroy();
			releaseCar();

			if( killCar )
			{
				player.car.destroy();
				player.car=null;
				killCar = 0;
			}

			//kill sky and sun
			remSceneElements();

			map.delTraffic();
			map.setPedestrianDensity( 0.0 );
			map.unload();

			osdEnabled = 0;
			enableOsd( osdEnabled );

			if( nav )
			{
				//nav.hide();
				nav.remMarker( mPlayer );	mPlayer=null;
			}

			osd.hide();
			osd=null;

			clearEventMask( EVENT_ANY );

			leaveAsyncMode_Script();

			GfxEngine.flush();

		}

		//allitsa vissza az 'idoszamitast' ha pl verseny vegen a lassitott mod kozben lepteti ki!
		System.timeWarp(1.0);


		player.controller.reset();
		player.controller.activateState( ControlSet.MENUSET );
	}

	//call this after camera settings have been changed
	public void resetCamera()
	{
		if( cameraMode == CAMMODE_TV || cameraMode == CAMMODE_FOLLOW )
		{
			cam.command( "render " + osd.getViewport().id() + " 0 0 1 " + (Viewport.RENDERFLAG_CLEARDEPTH | Viewport.RENDERFLAG_CLEARTARGET) );
			renderer = cam;
		}
//		else
//			System.log( "cannot reset unsupported cam type" );
	}


	public void changeCamTV( )//Vector3 destPos )
	{
		if ( !cameraTarget ) return;
		if ( !cameraTarget.id() ) return;
		Vector3	destPos = cameraTarget.getPos();
		if ( !destPos ) return;
		Vector3 actdestPos = new Vector3(destPos);
        Vector3 vel = cameraTarget.getVel();
		if (vel)
		{
			vel.mul(3.0f);
			destPos.add(vel);
		}

		if( cameraMode == CAMMODE_INTERNAL && !cameraNum )
			player.car.command( "filter 3 0" );	//running geart kifilterezzuk

		Vector3 camPos;

		if (cameraMode == CAMMODE_FREE)
		{
			player.controller.command( "leave " + cam.id() );
			player.controller.command( "controllable " + player.car.id() );
			player.controller.activateState( 5, 0 );

			lastCrossPos = map.getNearestCross( destPos, 0 );	//ToDo: getnearestCamera
			if (cam)
				camPos = cam.getPos();
			else
				camPos = destPos;
		} else
		{
			camPos = map.getNearestCross( destPos, 0 );	//ToDo: getnearestCamera
			if (camPos)
			{
				if (cameraMode == CAMMODE_TV)
				if (lastCrossPos)
				if (camPos.distance( lastCrossPos ) < 0.1)
				{
					//ha esetleg valtozott a cameratarget...
					ResourceRef bone = new ResourceRef(	cameraTarget.getInfo(GameType.GII_BONE) );
					cam.command( "look " + bone.id() + " 0,0,-1" );

					return;
				}
				lastCrossPos = new Vector3(camPos);
				camPos.y += 0.2 + 3.0*Math.random();
			} else
			{
				if (cam)
					camPos = cam.getPos();
				else
					camPos = destPos;
				if (!camPos)
					camPos = lastCamPos;
			}

			if (cameraMode == CAMMODE_TV)
			{
				if (lastCamPos)
				{
					if (camPos.distance( lastCamPos ) < 0.1)
						return;
					if (lastCamPos.distance(actdestPos) < camPos.distance(actdestPos))
						return;	//jobb a mostani
				}
			} else
				addTimer( 3,3 );	//start changing cameras every 3 seconds
		}

		changeCamNone();
		if (!camPos)	return;

		Vector3 pTemp = new Vector3(actdestPos);
		pTemp.sub( camPos );
		Ypr yTemp = new Ypr( pTemp );

//		cam = new GameRef( map, GameRef.RID_CAMERA, camPos.toString() + "," + yTemp.toString() + ",0x06", "track tv cam" );
		cam = new GameRef( map, GameRef.RID_CAMERA, camPos.toString() + "," + yTemp.toString() + ",0x02", "track tv cam" );
		cam.command( "autozoom 1 0 " + (0.2+Math.random()*0.8) + " " + (Math.random()*0.2) );
		cam.command( "render " + osd.getViewport().id() + " 0 0 1 " + (Viewport.RENDERFLAG_CLEARDEPTH | Viewport.RENDERFLAG_CLEARTARGET) );
		renderer = cam;
		cam.command( "torque 0.1" );
		cam.command( "roll " + (Math.random()-0.5) );

		lastCamPos = new Vector3(camPos);
		cameraMode = CAMMODE_TV;

//		if (cameraTarget)
//		{
//			GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
//			con.command( "viewport 0");// + osd.getViewport().id() );
			ResourceRef bone = new ResourceRef(	cameraTarget.getInfo(GameType.GII_BONE) );
			cam.command( "look " + bone.id() + " 0,0,-1" );
//			if ( osdEnabled )
//				cameraTarget.command( "osd "+ osd.id() +" "+ con.id());	//enable osd
//		} else
//			cam.command( "look " + map.id() + destPos.toString() );
	}

	public void changeCamInternal( )//Vector3 pos )
	{
		if (!cameraTarget)	return;
		if (!cameraTarget.id())	return;

		if (cameraMode == CAMMODE_FREE)
		{
			player.controller.command( "leave " + cam.id() );
			player.controller.command( "controllable " + player.car.id() );
			player.controller.activateState( 5, 0 );
		}

//		changeCamNone();

		int cameras = cameraTarget.getInfo( GameType.GII_RENDER );
		if (cameras == 0)	return;

		if (cameraMode == CAMMODE_INTERNAL)
		{//change to _next_ int.cam.
			if (++cameraNum >= cameras)
				cameraNum = 0;

			GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
			cameraTarget.command( "render " + osd.getViewport().id() +" "+ con.id() +" "+ cameraNum);
			renderer = cameraTarget;
		} else
		{
			GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
			if (cam)
			{
				lastCamPos = cam.getPos();
				cam.command( "hide " + osd.getViewport().id());
				if (cam != cam_external)
					cam.destroy();	//TV
			}

			if (cameraNum < 0)
				cameraNum = (-cameraNum)%cameras;
			else
				cameraNum = 0;

			cameraTarget.command( "render " + osd.getViewport().id() +" "+ con.id() +" "+ cameraNum);
			renderer = cameraTarget;
//			if ( osdEnabled )
//				cameraTarget.command( "osd 0 " + con.id());	//disable osd
		}
		cameraMode = CAMMODE_INTERNAL;

		if( !cameraNum )
			player.car.command( "filter 3 2" );	//running geart kifilterezzuk
		else
			player.car.command( "filter 3 0" );	//running geart kifilterezzuk

	}

	public void changeCamInternal( int num )
	{
		if (cameraMode == CAMMODE_INTERNAL)
			cameraNum = num-1;
		else
			cameraNum = -num;
		changeCamInternal();
	}

	void makeCamExternal()	//ennek ki kellene kapcsolnia a renderert, ha az nem az ext. cam.
	{
		Vector3	pos;

		if (cameraMode == CAMMODE_FREE)
		{
			player.controller.command( "leave " + cam.id() );
			player.controller.command( "controllable " + player.car.id() );
			player.controller.activateState( 5, 0 );
		}

		if( cameraMode == CAMMODE_INTERNAL && !cameraNum )
			player.car.command( "filter 3 0" );	//running geart kifilterezzuk


		if (cam_external)
			if (!cam_external.id())
				cam_external = null;	//drop

		if( cam_external )
		{
			if (renderer)
			if (renderer != cam_external)
			{
				renderer.command( "hide " + osd.getViewport().id());
				renderer = null;
			}
/*			if (cameraMode == CAMMODE_INTERNAL)
			{
//				GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
				cameraTarget.command( "hide " + osd.getViewport().id());// +" "+ con.id());
//				if ( osdEnabled )
//					cameraTarget.command( "osd "+ osd.id() +" "+ con.id());	//enable osd
			}
*/			if (cam && cam != cam_external)
			{
				cam.destroy();	//TV
				cam = null;
			}

			cam = cam_external;
		}

		if (!cam_external)
		{
			changeCamNone();
			
			if (lastCamPos)
				pos = lastCamPos;
			else
				pos = new Vector3(0,-10000,0);	//patch
				
			Vector3 pTemp = cameraTarget.getPos();
			if (!pTemp)
			{
//				System.log("Missing cameratarget! Ext.camera not created!");
				return;
			}
			Ypr yTemp;
			pTemp.sub( pos );

			//ha tul mesze ment (tvben), lerakjuk moge
			if( pTemp.length() > 70.0 )
			{
				pos = cameraTarget.getPos();
				if (!pos)	return;
				Vector3 displ = new Vector3( pTemp );
				displ.normalize();
				displ.mul( 5.0 );

				pTemp = new Vector3( pos );
				pos.sub( displ );
				pos.y+=2.0;

				pTemp.sub( pos );

				yTemp = new Ypr( pTemp );
			}
			else
			{
				yTemp = new Ypr( pTemp );
			}

			cam = new GameRef( map, GameRef.RID_CAMERA, pos.toString() + "," + yTemp.toString() + ",0x02, 1.0,0, 0.01", "external track cam" );
			cam_external = cam;

			lastCamPos = new Vector3(pos);
		} 
	}

	public void changeCamFollow( )//Vector3 pos )
	{
		makeCamExternal();

		cam.command( "dist 2.5 10.0");
		cam.command( "smooth 0.5 0.5");
		cam.command( "force 1.6 0.5 -0.7" );	//defaults are in config.java
		cam.command( "torque 0.1" );
		cam.command( "roll 0" );
		cam.command( "render " + osd.getViewport().id() + " 0 0 1 " + (Viewport.RENDERFLAG_CLEARDEPTH | Viewport.RENDERFLAG_CLEARTARGET) );
		renderer = cam;

		GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
		con.command( "viewport " + osd.getViewport().id() );
		con.command( "camera " + cam.id() );

		cameraMode = CAMMODE_FOLLOW;
	}

	public void changeCamPoint( Vector3 pos )
	{
		makeCamExternal();

		GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
		con.command( "viewport 0");// + osd.getViewport().id() );
		ResourceRef bone = new ResourceRef(	cameraTarget.getInfo(GameType.GII_BONE) );

		Vector3 pTemp = cameraTarget.getPos();
		if (!pTemp)	return;
		pTemp.sub( pos );
		Ypr yTemp = new Ypr( pTemp );

		cam.command( "render " + osd.getViewport().id() + " 0 0 1 " + (Viewport.RENDERFLAG_CLEARDEPTH | Viewport.RENDERFLAG_CLEARTARGET) );
		renderer = cam;
		cam.command( "move " + bone.id() + " 0,1,0 0.1 0,-0.2,-3" );
		cam.command( "look " + map.id() + " "+pos.x+","+pos.y+","+pos.z );
		cam.command( "roll " + (Math.random()-0.5) );
		cameraMode = CAMMODE_POINT;
	}

	public void changeCamChase()
	{
		if (!cameraTarget2)
		{
			changeCamFollow();
		} else
		if (!cameraTarget2.id())
		{
			changeCamFollow();
		} else
		{
			makeCamExternal();

			GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
			con.command( "viewport 0");// + osd.getViewport().id() );
			ResourceRef bone = new ResourceRef(	cameraTarget.getInfo(GameType.GII_BONE) );
			cam.command( "render " + osd.getViewport().id() + " 0 0 1 " + (Viewport.RENDERFLAG_CLEARDEPTH | Viewport.RENDERFLAG_CLEARTARGET) );
			renderer = cam;
//			cam.command( "move " + bone.id() + " 0,1,0 0.1 0,-0.2,-8" );
			float roll = Math.random()-0.5;
			cam.command( "move " + bone.id() + " 0,"+(Math.random())+",0 0.01 " + roll*-3.0 + ",-0.2," + (-3-5*Math.random()) );
			cam.command( "look " + cameraTarget2.id() + " 0,0,-1 " + roll*0.6 + ",0,-1" );
			cam.command( "roll " + roll );
			cam.command( "zoom " + (20.0+70.0*Math.random()) +" 5" );
		}
		cameraMode = CAMMODE_CHASE;
	}

	public void changeCamInvChase()
	{
		if (!cameraTarget2)
		{
			changeCamFollow();
		} else
		if (!cameraTarget2.id())
		{
			changeCamFollow();
		} else
		{
			makeCamExternal();

			GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
			con.command( "viewport 0");// + osd.getViewport().id() );
			ResourceRef bone = new ResourceRef(	cameraTarget2.getInfo(GameType.GII_BONE) );
			cam.command( "render " + osd.getViewport().id() + " 0 0 1 " + (Viewport.RENDERFLAG_CLEARDEPTH | Viewport.RENDERFLAG_CLEARTARGET) );
			renderer = cam;
//			cam.command( "move " + bone.id() + " 0,1,0 0.1 0,-0.2,-8" );
//			cam.command( "look " + cameraTarget.id() + " 0,0,-1" );
			float roll = Math.random()-0.5;
			cam.command( "move " + bone.id() + " 0,"+(Math.random())+",0 0.01 " + roll*-3.0 + ",-0.2," + (-3-5*Math.random()) );
			cam.command( "look " + cameraTarget.id() + " 0,0,-1 " + roll*0.6 + ",0,-1" );
			cam.command( "roll " + roll );
			cam.command( "zoom " + (20.0+70.0*Math.random()) +" 5" );
		}
		cameraMode = CAMMODE_INVCH;
	}

	public void changeCamFree()
	{
//'freestyle' camera for debug
		makeCamExternal();
		player.controller.command( "leave " + player.car.id() );
		player.controller.command( "controllable " + cam.id() );
		player.controller.activateState( 5, 1 );
		cameraMode = CAMMODE_FREE;
	}

	public void enablePicInPic()
	{
//debug test:
//		vport2 = new Viewport( 12, 0.1, 0.1, 0.3, 0.3 );
		vport2 = new Viewport( 12, 0.99, 0.01, 0.3, 4.0/3.0, -1.0, 0.0 );
		vport2.activate( Viewport.RENDERFLAG_CLEARDEPTH | Viewport.RENDERFLAG_CLEARTARGET );
		GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
		cameraTarget.command( "render " + vport2.id() +" "+ con.id() +" "+ cameraNum);
//		renderer = cameraTarget;
	}

	public void changeCamNone()
	{
		if (renderer)
		{
			renderer.command( "hide " + osd.getViewport().id());
			renderer = null;
		}

		if( cameraMode == CAMMODE_INTERNAL && !cameraNum )
			player.car.command( "filter 3 0" );	//running geart kifilterezzuk

/*		if (cameraMode == CAMMODE_INTERNAL)
		{
//			GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
			cameraTarget.command( "hide " + osd.getViewport().id());// +" "+ con.id());
		}
*/		if( cam )
		{
			cam.destroy();
			if (cam_external == cam)
				cam_external = null;
			if (renderer == cam)
				renderer = null;
			cam = null;
		}
	}

	public void refreshCamera()
	{
		if (cameraMode == CAMMODE_FOLLOW)
			changeCamFollow();
		else
		if (cameraMode == CAMMODE_INTERNAL)
			changeCamInternal();
		else
		if (cameraMode == CAMMODE_TV)
			changeCamTV();
		else
		if (cameraMode == CAMMODE_CHASE)
			changeCamChase();
		else
		if (cameraMode == CAMMODE_INVCH)
			changeCamInvChase();
	}

	public void changeCamTarget( GameRef obj )
	{
		if (cameraTarget == obj)
			return;
//		if (cameraMode == CAMMODE_INTERNAL)
		if (renderer && cameraTarget)
		if (renderer.id() == cameraTarget.id())
		{
			renderer.command( "hide " + osd.getViewport().id());
			renderer = null;
		}
		cameraTarget = obj;
		refreshCamera();
	}

	public void changeCamTarget2( GameRef obj )
	{
		if (cameraTarget2 == obj)
			return;
		if (renderer && cameraTarget2)
		if (renderer.id() == cameraTarget2.id())
		{
			renderer.command( "hide " + osd.getViewport().id());
			renderer = null;
		}
		cameraTarget2 = obj;
		if ((cameraMode == CAMMODE_CHASE)
		 || (cameraMode == CAMMODE_INVCH))
			refreshCamera();
	}

	public Trigger addTrigger( Trigger t, Vector3 pos, RenderRef marker, String handler )
	{
		trigger.addElement(t);
		addNotification( t.trigger, EVENT_TRIGGER_ON, EVENT_SAME, null, handler );
		addNotification( t.trigger, EVENT_TRIGGER_OFF, EVENT_SAME, null, handler );
		
		if( marker )
		{
			t.marker = nav.addMarker( marker, pos, 0 );
			t.nav = nav;
		}

		return t;
	}


	public Trigger addTrigger( Vector3 pos, GameRef type, RenderRef marker, String handler, float r, String alias )
	{
		return addTrigger( new Trigger( map, null, pos, r, alias ), pos, marker, handler );
	}

	public void removeTrigger( Trigger t )
	{
		if( t )
		{
			remNotification( t.trigger, EVENT_TRIGGER_ON|EVENT_TRIGGER_OFF );
			trigger.removeElement(t);
			t.finalize();
		}
	}

	//el/visszaveszi a kocsit a playertol
	public void lockCar()
	{
		if (player.car)
		{
			player.car.setParent( map );
			player.car.setMatrix( posStart, oriStart );
			player.car.command( "reset" );
			player.car.command( "reload" );	//Fuel and NOS
		}
	}

	public void releaseCar()
	{
		if (player.car)
		{
			player.car.setParent( player );
			player.car.command( "reset" );
		}
	}


	public void setMessage( String str )
	{
		messages.changeText( str );
		addTimer( 2, 0 );
		++msgtimers;
	}

	public void handleEvent( GameRef obj_ref, int event, int param )
	{
		//intet kellene visszadnia, jelezve, hogy feldolgozta-e az uzenetet!
		if( event == EVENT_TIME )
		{
			if( param == 0 )
			{
				if( !--msgtimers )
					messages.changeText( "" );	
			}
			else
			if( param == 2 )
			{
				addTimer( 1, 2 );	//one sec tick

				if( GameLogic.timeout )
				{
					if( !--GameLogic.timeout )
						GameLogic.changeActiveSection( parentState );
				}
			}
			else
			if( param == 3 )
			{
				if( cameraMode == CAMMODE_TV )
				{
//					if (player.car)
						changeCamTV();
					addTimer( 3, 3 ); //3mp-kent keresunk neki uj post
				}
			}
			else
			if( param == 4 )
			{
				if ( GameLogic.gameMode == GameLogic.GM_DEMO )
				{//random camera changes
					int	changed = 0;
					if (Math.random() > 0.3f)
					{
						int cam = 2.0*Math.random();
						cameraMode = 2+cam%3;
						changed++;
					} else
					{
						int	cam = 3.0*Math.random();
						changeCamInternal(1+cam%3);
					}

					if (Math.random() > 0.7f)
						if (cameraTarget2)
						{
							GameRef			t2 = cameraTarget2;
							
							if (renderer && cameraTarget)
							if (renderer.id() == cameraTarget.id())
							{
								renderer.command( "hide " + osd.getViewport().id());
								renderer = null;
							}
							cameraTarget2 = cameraTarget;
							cameraTarget = t2;
							changed++;
						}
					if (changed)
					{
						refreshCamera();
						addTimer (5, 4 );
					} else
					{
						addTimer (2, 4 );
					}
				}
			}
		}
	}


	public void handleEvent( GameRef obj_ref, int event, String param )
	{
		int	tok = -1;

		if( event == EVENT_CURSOR )
		{
			int	ec = param.token( ++tok ).intValue();

			int	cursor_id = param.token( ++tok ).intValue();
			if (ec == GameType.EC_RCLICK)
			{
				GameRef dest = new GameRef(param.token( ++tok ).intValue());
				int cat = dest.getInfo(GameType.GII_CATEGORY);
				if( cat == GIR_CAT_PART || cat == GIR_CAT_VEHICLE )
//					cam.command( "look " + dest.id() + " 0,0,0" );
					cam.command( "look " + dest.id() + " " + param.token( ++tok ) + "," + param.token( ++tok ) + "," + param.token( ++tok ) );
			} 
		}
	}


	public void handleMessage( Message m )
	{
		if( m.type == Message.MT_EVENT )
		{
			int	cmd=m.cmd;

			if( cmd == CMD_CRUISECONTROL )
			{
				int newCruise = 1-player.car.getCruiseControl();
				player.car.setCruiseControl( newCruise );
				if( newCruise )
					setMessage( "Cruise control on" );
				else
					setMessage( "Cruise control off" );
			}
			else
			if( cmd == CMD_CAMMOVE )
			{
				if( ((Event)m).flags )
				{	//press
					player.controller.user_Add( Input.AXIS_LOOK_UPDOWN,	ControlSet.MOUSE, 1,	-1.0f, 1.0f, -1.0f, 1.0f);
					player.controller.user_Add( Input.AXIS_LOOK_LEFTRIGHT,	ControlSet.MOUSE, 0,	-1.0f, 1.0f, -1.0f, 1.0f);
				}
				else
				{	//release
					player.controller.user_Del( Input.AXIS_LOOK_UPDOWN,	ControlSet.MOUSE, 1 );
					player.controller.user_Del( Input.AXIS_LOOK_LEFTRIGHT,	ControlSet.MOUSE, 0 );
				}
			} else

			if( cmd == CMD_CHANGECAM_TV )
			{
//				if( cameraMode != CAMMODE_TV )
//				{
					changeCamTV();
//				}
			} else
			if( cmd == CMD_CHANGECAM_INT )
			{
				changeCamInternal();
			} else
			if( cmd == CMD_CHANGECAM_EXT )
			{
				if (cameraMode != CAMMODE_FOLLOW)
				{
					changeCamFollow();
				}
			} else
			if( cmd == CMD_CHANGECAM_CHASE )
			{
				changeCamChase();
			} else
			if( cmd == CMD_CHANGECAM_INVCH )
			{
				changeCamInvChase();
			} else
			if( cmd == CMD_CHANGECAM_FREE )
			{
				changeCamFree();
//				enablePicInPic();
			} else
			if( cmd == CMD_CHANGECAMTARGET )
			{
				if (cameraTarget2)
				{
					GameRef			t2 = cameraTarget2;

					if (renderer && cameraTarget)
					if (renderer.id() == cameraTarget.id())
					{
						renderer.command( "hide " + osd.getViewport().id());
						renderer = null;
					}
					if (renderer && cameraTarget2)
					if (renderer.id() == cameraTarget2.id())
					{
						renderer.command( "hide " + osd.getViewport().id());
						renderer = null;
					}

					{
						GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
						con.command( "viewport 0");
						con.command( "osd 0" );
						cameraTarget.command( "osd 0 " + con.id());//disable osd
					}

					cameraTarget2 = cameraTarget;
					cameraTarget = t2;

					{
						GameRef con = new GameRef(cameraTarget.getInfo(GII_OWNER));
						con.command( "viewport " + osd.getViewport().id() );
						con.command( "osd " + osd.id() );
						cameraTarget.command( "osd "+ osd.id() +" "+ con.id());	//enable osd
					}

					refreshCamera();
				}
			} else

			if( cmd == CMD_OSDONOFF )
			{
				osdEnabled = 1-osdEnabled;
				enableOsd( osdEnabled );
			} 
			else
			if( cmd == CMD_CAMROTATE )
			{
				if( camRotate )
				{
					cam.command( "angle 0 0" );		//0.7853 = (2*pi)/8.0
				}
				else
				{
					cam.command( "angle 0 8.0 0.7853" );		//0.7853 = (2*pi)/8.0
				}

				camRotate = 1-camRotate;
			} else
			if( cmd == CMD_QUICKREPAIR )
			{
				if (player.car)
					player.car.repair();
			}
			else
			if( cmd == CMD_SIMPAUSE )
			{	// !=0.0 <-> 0.0
				if ( System.timeWarp(-1.0) > 0.0 )
				{
					System.timeWarp(0.0);
					cam.command( "simulate 1" );
				}
				else
				{
					cam.command( "simulate 0" );
					System.timeWarp( 1.0 );
					if( camRotate )
						cam.command( "angle 0 10.0 0.7853" );		//0.7853 = (2*pi)/8.0
				}
			}
			else
			if( cmd == CMD_SIMSPEEDINC )
			{
				float t = 2.0*System.timeWarp(-1.0);
				if( t < 1.0 )
				{
					if( t == 0.0 )
						t = 1.0/64;
					System.timeWarp( t );
					cam.command( "simulate 1" );
					if( camRotate )
						cam.command( "angle 0 10.0 0.7853" );		//0.7853 = (2*pi)/8.0
				}
				else
				{
					System.timeWarp(1.0);
					cam.command( "simulate 0" );
					if( camRotate )
						cam.command( "angle 0 10.0 0.7853" );		//0.7853 = (2*pi)/8.0
				}
			} 
			else
			if( cmd == CMD_SIMSPEEDDEC )
			{
				float t = 0.5*System.timeWarp(-1.0);
				if (t < 1.0/64)
					t = 0.0;
				System.timeWarp(t);
				if( camRotate )
					cam.command( "angle 0 10.0 0.7853" );		//0.7853 = (2*pi)/8.0
				if( t < 1.0 )
					cam.command( "simulate 1" );
				else
					cam.command( "simulate 0" );
			} 
			else
			if( cmd == CMD_INGAMEMENU )
			{
				if( mc_active )
					osdCommand( CMD_MECHANIC );
				else
				if( pt_active )
					osdCommand( CMD_PAINT );
				else
				{
					if( im_active )
					{
						ingameMenu.hide();

						//hatha valtozott az ingamemenuben!!
						player.car.setDefaultTransmission();
						player.car.setDefaultSteeringHelp();
						player.car.setDefaultASR();
						player.car.setDefaultABS();

						//hatha valtozott a gpsmode?
						if(	nav )
							nav.changeMode( Config.gpsMode );


						//System.timeWarp(1.0);

						if( ingameMenu.reqTrackExit )
						{
							int spec;

							if( this instanceof ROCTrack )
							{
								if( !this.testMode )
								{
									spec = 1;
								}
							}

							if( spec )
								this.giveUpRace();
							else
								GameLogic.changeActiveSection( parentState );
						}
					}
					else
					{
						//System.timeWarp(0.0);
						ingameMenu.show();
						if( cam && cam.id() )
							ingameMenu.setActiveCamera( cam );
					}

					im_active=1-im_active;
				}
			}
			else
			if( cmd == CMD_EXIT )
			{
				if( mc_active )
					osdCommand( CMD_MECHANIC );

				if( pt_active )
					osdCommand( CMD_PAINT );

				if( im_active )
					osdCommand( CMD_INGAMEMENU );

				GameLogic.changeActiveSection( parentState );
			}
			else
			if( cmd == CMD_MECHANIC )
			{
				if( mc_active )
				{
					cam.command( "dist 2.5 10.0");
					cam.command( "smooth 0.5 0.5");
					cam.command( "force 1.6 0.4 -0.4" );
					cam.command( "torque 0.05" );
					player.controller.command( "camera" + cam.id() );

					Input.cursor.remHandler(this);	//kivancsiak vagyunk ra, mit csinal az eger
					player.car.command( "start" );	//release
					mechanic.hide();
					mechanic.filterInventory( 1,1,1 );
					enableOsd(1);
				}
				else
				{
					enableOsd(0);
					mechanic.filterInventory( 0,0,0 );
					mechanic.show();
					cam.command( "look " + player.car.id() + " 0,0,0 0,0,0 0.2" );
					cam.command( "move " + player.car.id() + " 0,0,0 3.5" );
					cam.command( "dist 2.5 4.6");
					cam.command( "smooth 0.05 0.5");
					player.car.command( "stop" );	//grab
					Input.cursor.addHandler(this);	//kivancsiak vagyunk ra, mit csinal az eger
				}

				mc_active=1-mc_active;
			}
			else
			if( cmd == CMD_PAINT )
			{
				if( pt_active )
				{
					cam.command( "dist 2.5 10.0");
					cam.command( "smooth 0.5 0.5");
					cam.command( "force 1.6 0.4 -0.4" );
					cam.command( "torque 0.01" );
					player.controller.command( "camera" + cam.id() );
					player.car.command( "start" );	//release
					painter.hide();
					enableOsd(1);
				}
				else
				{
					enableOsd(0);

					painter.show();
					cam.command( "look " + player.car.id() + " 0,0,0 0,0,0 0.2" );
					cam.command( "move " + player.car.id() + " 0,0,0 3.5" );
					cam.command( "dist 2.5 4.6");
					cam.command( "smooth 0.05 0.5");
					player.car.command( "stop" );	//grab
				}

				pt_active=1-pt_active;
			}

		}
	}

	public void osdCommand( int cmd )
	{
		mp.putMessage( new Event( cmd ) );
	}

	public void enableOsd( int enable )
	{
		if( enable )
		{
			osdCounter++;
			if( osdCounter == 1 )	// 0 -> 1
			{
				player.showOsd();
				if( nav )
					nav.show();
				//osd.show(0);	//csak screenshotozashoz!!
			}
		}
		else
		{
			osdCounter--;
			if( osdCounter == 0 )	// 1 -> 0
			{
				player.hideOsd();
				if( nav )
					nav.hide();
				//osd.hide(0);	//csak screenshotozashoz!!
			}
		}
	}
}

