package java.game;

import java.io.*;
import java.util.*;
import java.util.resource.*;
import java.render.*;	//Text
import java.render.osd.*;	//Text
import java.render.osd.dialog.*;	//Text
import java.sound.*;

public class OptionsDialog extends Dialog
{
	final static ResourceRef	RID_GENERALBG = new ResourceRef( frontend:0x0016r );
	
	// commands
	final static int	CMD_OPTIONS = 0;
	final static int	CMD_VIDEO_OPTIONS = 1;
	final static int	CMD_CONTROL_OPTIONS = 2;
	final static int	CMD_SOUND_OPTIONS = 3;
	final static int	CMD_REDEFINE_CONTROLS = 4;
	final static int	CMD_MAIN = 5;
	final static int	CMD_REDEFINE_DONE = 6;
	final static int	CMD_RESET_CONTROLS = 7;
	final static int	CMD_LOAD_CONTROLS = 8;
	final static int	CMD_SAVE_CONTROLS = 9;
	final static int	CMD_RESOLUTION = 10;
	final static int	CMD_VIDEO_OPTIONS_DONE = 11;
	final static int	CMD_TEXTURE_DETAIL = 12;
	final static int	CMD_SHADOW_DETAIL = 13;
	final static int	CMD_VIEW_RANGE = 14;
	final static int	CMD_EFFECTS_VOL = 15;
	final static int	CMD_MUSIC_VOL = 16;
	final static int	CMD_ENGINE_VOL = 17;
	final static int	CMD_GAME_OPTIONS = 18;
	final static int	CMD_DIFFICULTY = 19;
	final static int	CMD_TRAFFICDENSITY = 20;
	final static int	CMD_PEDESTRIANDENSITY = 21;
	final static int	CMD_CLUTCH = 22;
	final static int	CMD_STEERHELP = 23;
	final static int	CMD_GAME_OPTIONS_DONE = 24;
	final static int	CMD_MOUSE_SENS = 25;

	final static int	CMD_REDEFINE_CONTROLS2 = 26;
	final static int	CMD_REDEFINE_CONTROLS3 = 27;
	final static int	CMD_METRIC = 28;
	final static int	CMD_GAMMA = 29;
	final static int	CMD_OBJECT_DETAIL = 30;
	final static int	CMD_LOD_DETAIL = 31;
	final static int	CMD_ABS_SLIDER = 32;
	final static int	CMD_ASR_SLIDER = 33;
	final static int	CMD_GPSMODE = 34;
	final static int	CMD_AXISCHECK = 35;
	final static int	CMD_AXISCHECK_DONE = 36;
	final static int	CMD_UNUSED = 37;
	final static int	CMD_SOUND_3D = 38;
	final static int	CMD_SOUND_HW = 39;
	final static int	CMD_GAME_OPTIONS2 = 40;
	final static int	CMD_HMF_1 = 41;
	final static int	CMD_HMF_2 = 42;
	final static int	CMD_HMF_3 = 43;
	final static int	CMD_PARTICLE = 44;
	final static int	CMD_HEADLIGHTS = 45;
	final static int	CMD_FLARES = 46;
	
	final static int	CMD_GETKEY = 100;
	final static int	CMD_DEAD_ZONE = 200;
	final static int	CMD_POWER = 300;
	final static int	CMD_FFB = 400;

	final static int	NCONTROLS = 25;

	static String[] soundHWText;
	static String[] detailTextOO;
	static String[] detailTextLMH;
	static String[] detailTextOLMH;
	static String[] metricSystemText;
	static String[] gpsText = new String[2];

	Player			player;

	int				getKey = -1;
	int				getName = -1;
	int				getKeyStat = 0;

	Text[]			keyText = new Text[NCONTROLS];

	String[]		clutchText = new String[4];
	int[]			clutchTrf, clutchTrfInv;

	Text			accelerateText,	brakeText, steeringText;

	int				axisCheckCallerGroup;

	int				mainGroup, optionsGroup, videoGroup, soundGroup, controlGroup, gameGroup, game2Group;
	int				redefineGroup, redefine2Group, redefine3Group, axisCheckGroup;

	int				actGroup;

	int				lastVideoMode;

	Vector			videoModesTxt = new Vector();
	Vector			videoModes = new Vector();

	int				videoMode;
	int				textureDetail;
	int				shadowDetail;

	MultiChoice		soundHWMulti;

	Slider[]		powerSlider;
	Slider[]		dzSlider;
	Slider[]		ffbSlider;

	Slider			acGasSlider, acBreakSlider, acSteerSlider, acClutchSlider;

	
	ControlSet		controlSet;


	Style butt0 = new Style( 0.45, 0.12, Frontend.mediumFont, Text.ALIGN_LEFT, Osd.RRT_TEST );
	Style butt1 = new Style( 0.45, 0.12, Frontend.mediumFont, Text.ALIGN_CENTER, Osd.RRT_TEST );
	Style butt2 = new Style( 0.45, 0.12, Frontend.mediumFont, Text.ALIGN_RIGHT, Osd.RRT_TEST );

	Style buttX = new Style( 0.1, 0.1, Frontend.mediumFont, Text.ALIGN_RIGHT, Osd.RRT_TEST );

	Style sld1 = new Style( 0.45, 0.06, Frontend.mediumFont, Text.ALIGN_LEFT, new ResourceRef(Osd.RID_SLD_BACK) );
	Style sldk =  new Style( 0.04, 0.05, Frontend.mediumFont, Text.ALIGN_RIGHT, new ResourceRef(Osd.RID_SLD_KNOB) );


	public OptionsDialog( int additionalFlags )
	{
		super( GameLogic.player.controller, additionalFlags|DF_FULLSCREEN|DF_LOWPRI, null, null );

		player=GameLogic.player;

		osd.globalHandler = this;

		actGroup = -1;

		detailTextOO = new String[2];
		detailTextOO[0] = "OFF";		
		detailTextOO[1] = "ON";		
		
		//= {}
		detailTextLMH = new String[3];
		detailTextLMH[0] = "LOW";		
		detailTextLMH[1] = "MEDIUM";		
		detailTextLMH[2] = "HIGH";		

		//= {}
		detailTextOLMH = new String[4];
		detailTextOLMH[0] = "OFF";		
		detailTextOLMH[1] = "LOW";		
		detailTextOLMH[2] = "MEDIUM";		
		detailTextOLMH[3] = "HIGH";		

		//
		soundHWText = new String[4];
		soundHWText[0] = "SOFTWARE (SLOW!)";
		soundHWText[1] = "HARDWARE (2D ONLY)";
		soundHWText[2] = "HARDWARE (FULL 3D)";
		soundHWText[3] = "AUTO";

		//
		clutchText[0] = "Auto+Autoclutch";
		clutchText[1] = "Semiauto+Autoclutch";
		clutchText[2] = "Manual+Autoclutch";
		clutchText[3] = "Manual+Clutch";

		clutchTrf = new int[6];	//player_transmission values -> clutch mode name indexes
		clutchTrf[0] = 2;
		clutchTrf[1] = 0;
		clutchTrf[2] = 3;
		clutchTrf[3] = -1;
		clutchTrf[4] = -1;
		clutchTrf[5] = 1;

		clutchTrfInv = new int[4];	//clutch mode name indexes -> player_transmission values
		clutchTrfInv[0] = 1;
		clutchTrfInv[1] = 5;
		clutchTrfInv[2] = 0;
		clutchTrfInv[3] = 2;

		metricSystemText = new String[2];
		metricSystemText[0]="Miles";
		metricSystemText[1]="Kilometres";

		gpsText[0] = "MAP RELATIVE";
		gpsText[1] = "CAR RELATIVE";
	}

	public void show()
	{
		//collect & filter video modes

		int maxVideoModes = GfxEngine.numDisplayModes();
		int	actVideoMode = GfxEngine.currDisplayMode();
		int	validModes;

		//filters in all reasonably sized fullscreen modes and the current video mode
		for( int i=0; i<maxVideoModes; i++ )
		{
			String videoModeTxt = GfxEngine.displayModeName(i);

			int w = videoModeTxt.token(0).intValue();
			int h = videoModeTxt.token(1).intValue();
			int d = videoModeTxt.token(2).intValue();

			if( (w >= 0 && w <= 2048  &&  h >= 0 && h <= 1536  &&  d >= 0 && d <= 32) )
			{
				if( i==actVideoMode )
				{
					videoMode = validModes;
				}

				videoModes.addElement( new VideoMode( w, h, d, 0 ) );
				videoModesTxt.addElement( w + " X " + h + " X " + d );

				validModes++;
			}
		}
		//add the current windowed mode, if present
		if( Config.video_windowed )
		{
			videoModes.addElement( new VideoMode( Config.video_x, Config.video_y, Config.video_depth, Config.video_windowed ) );
			videoModesTxt.addElement( "Windowed Mode" );
			videoMode = videoModes.size()-1;
		}

		//find out the current settings
		lastVideoMode = videoMode;

		if( Config.texture_size <= Config.texture_size_high )
			textureDetail = Config.HIGH;
		else 
		if( Config.texture_size <= Config.texture_size_mid )
			textureDetail = Config.MID;
		else
			textureDetail = Config.LOW;


		if( Config.shadow_detail >= Config.shadow_detail_off )
			shadowDetail = Config.OFF;
		else 
		if( Config.shadow_detail >= Config.shadow_detail_low )
			shadowDetail = Config.LOW;
		else
		if( Config.shadow_detail >= Config.shadow_detail_mid )
			shadowDetail = Config.MID;
		else
			shadowDetail = Config.HIGH;

		float x, y, spc;
		float lpos = -1.0, mpos = -0.10;

		//--------------main menu--------------
		addCustomGroups();

		//--------------options menu--------------
		Menu m;

		osd.createBG( RID_GENERALBG );
		osd.createHeader( "OPTIONS" );

		m = osd.createMenu( butt1, 0.0, -0.6, 0 );
		m.addItem( "VIDEO OPTIONS", CMD_VIDEO_OPTIONS );
		m.addItem( "SOUND OPTIONS", CMD_SOUND_OPTIONS );
		m.addItem( "CONTROL OPTIONS", CMD_CONTROL_OPTIONS );
		m.addItem( "GAME OPTIONS", CMD_GAME_OPTIONS );
		m.addItem( "ADVANCED GAME OPTIONS", CMD_GAME_OPTIONS2 );

		m = osd.createMenu( butt2, 0.98, 0.85, 0 );
		m.addItem( "BACK", CMD_MAIN );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_MAIN, this );
		osd.hideGroup( optionsGroup = osd.endGroup() );

		//-----------video options menu--------------

		osd.createBG( RID_GENERALBG );
		osd.createHeader( "VIDEO OPTIONS" );

		m = osd.createMenu( butt0, 0.0, -0.6, 0 );
		m.setSliderStyle( sld1, sldk );

		m.addItem( "SCREEN RESOLUTION", CMD_RESOLUTION, videoMode, videoModesTxt, null );
		m.addItem( "TEXTURE DETAIL", CMD_TEXTURE_DETAIL, textureDetail, detailTextLMH, null );
		m.addItem( "SHADOW DETAIL", CMD_SHADOW_DETAIL, shadowDetail+1, detailTextOLMH, null );
		m.addItem( "VIEW RANGE", CMD_VIEW_RANGE, Config.camera_ext_viewrange, 100.0, 400.0, 0, null ).printValue( "%.2f m" );
		m.addItem( "OBJECT DETAIL", CMD_OBJECT_DETAIL, Config.object_detail, 0.0747, 0.010, 0, null );//.printValue( "%.4f" );
		m.addItem( "LOD DETAIL", CMD_LOD_DETAIL, Config.object_detail_amp, 28.0, 5.5, 0, null );//.printValue( "%.1f" );
		m.addItem( "PARTICLE DENSITY", CMD_PARTICLE, Config.particle_density, 0.0, 0.6, 5, null );//.printValue( "%.1f" );
		m.addItem( "HEADLIGHT RAYS", CMD_HEADLIGHTS, Config.headlight_rays, detailTextOO, null );
		m.addItem( "FLARES", CMD_FLARES, Config.flares, detailTextOO, null );
		m.addItem( "GAMMA", CMD_GAMMA, Config.video_gamma, 0.5, 2.0, 0, null ).printValue( "%.2f" );

		m = osd.createMenu( butt2, 0.98, 0.85, 0 );
		m.addItem( "BACK", CMD_VIDEO_OPTIONS_DONE );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_VIDEO_OPTIONS_DONE, this );
		osd.hideGroup( videoGroup = osd.endGroup() );


		//-----------sound options menu--------------

		osd.createBG( RID_GENERALBG );
		osd.createHeader( "SOUND OPTIONS" );

		m = osd.createMenu( butt0, 0.0, -0.6, 0 );
		m.setSliderStyle( sld1, sldk );

		m.addItem( "EFFECTS VOLUME", CMD_EFFECTS_VOL, Sound.getVolume(Sound.CHANNEL_EFFECTS), null );
		m.addItem( "MUSIC VOLUME", CMD_MUSIC_VOL, Sound.getVolume(Sound.CHANNEL_MUSIC), null );
		m.addItem( "ENGINE VOLUME", CMD_ENGINE_VOL, Sound.getVolume(Sound.CHANNEL_ENGINE), null );
		m.addSeparator();
		soundHWMulti = m.addItem( "MIXING", CMD_SOUND_HW, 0, soundHWText, null );

		m = osd.createMenu( butt2, 0.98, 0.85, 0 );
		m.addItem( "BACK", CMD_OPTIONS );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_OPTIONS, this );
		osd.hideGroup( soundGroup = osd.endGroup() );

		//---------controller options menu--------------

		osd.createBG( RID_GENERALBG );
		osd.createHeader( "CONTROL OPTIONS" );

		m = osd.createMenu( butt1, 0.0, -0.6, 0 );

		m.addItem( "REDEFINE CAR CONTROLS", CMD_REDEFINE_CONTROLS );
		m.addItem( "REDEFINE GAME CONTROLS", CMD_REDEFINE_CONTROLS2 );
		m.addItem( "ADVANCED SETTINGS", CMD_REDEFINE_CONTROLS3 );
		m.addItem( "RESET TO DEFAULTS", CMD_RESET_CONTROLS );
		m.addItem( "LOAD CONTROLS", CMD_LOAD_CONTROLS );
		m.addItem( "SAVE CONTROLS", CMD_SAVE_CONTROLS );

		m = osd.createMenu( butt2, 0.98, 0.85, 0 );
		m.addItem( "BACK", CMD_OPTIONS );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_OPTIONS, this );
		osd.hideGroup( controlGroup = osd.endGroup() );

		//-------car controller options menu--------------

		osd.createBG( RID_GENERALBG );
		osd.createHeader( "REDEFINE CAR CONTROLS" );
		osd.createText( "   PRIMARY CONTROLS", Frontend.mediumFont, Text.ALIGN_LEFT, lpos, -0.7 );

		m = osd.createMenu( butt0, -1.0, -0.45, 0 );

		m.addItem( "ACCELERATE", CMD_GETKEY + 0 );
		m.addItem( "BRAKE", CMD_GETKEY + 1 );
		m.addItem( "TURN LEFT", CMD_GETKEY + 2 );
		m.addItem( "TURN RIGHT", CMD_GETKEY + 3 );
		m.addItem( "HAND BRAKE", CMD_GETKEY + 4 );
		m.addItem( "SHIFT UP", CMD_GETKEY + 5 );
		m.addItem( "SHIFT DOWN", CMD_GETKEY + 6 );
		m.addItem( "CLUTCH", CMD_GETKEY + 7 );
		m.addItem( "ENGAGE NOS", CMD_GETKEY + 8 );
		m.addItem( "HONK HORN", CMD_GETKEY + 9 );

		osd.createText( "   SECONDARY CONTROLS", Frontend.mediumFont, Text.ALIGN_LEFT, mpos, -0.7 );

		m = osd.createMenu( butt0, -0.1, -0.45, 0 );

		m.addItem( "ACCELERATE", CMD_GETKEY + 15 );
		m.addItem( "BRAKE", CMD_GETKEY + 16 );
		m.addItem( "TURN LEFT", CMD_GETKEY + 17 );
		m.addItem( "TURN RIGHT", CMD_GETKEY + 18 );
		m.addItem( "HAND BRAKE", CMD_GETKEY + 19 );
		m.addItem( "SHIFT UP", CMD_GETKEY + 20 );
		m.addItem( "SHIFT DOWN", CMD_GETKEY + 21 );
		m.addItem( "CLUTCH", CMD_GETKEY + 22 );
		m.addItem( "ENGAGE NOS", CMD_GETKEY + 23 );
		m.addItem( "HONK HORN", CMD_GETKEY + 24 );

		m = osd.createMenu( butt2, 0.98, 0.85, 0,  Osd.MD_HORIZONTAL );
		m.addItem( "BACK", CMD_REDEFINE_DONE );
		m.addItem( "CHECK AXES", CMD_AXISCHECK );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_REDEFINE_DONE, this );

		x = -0.40;
		y = -0.48;
		for (int i = 0; i < NCONTROLS; i++)
		{
			if( i == 10 )
			{
				y += 0.6;
			}
			if( i == 15 )
			{
				x = 0.50;
				y = -0.48;
			}
			if (i < 10 || i > 14)
				keyText[i] = osd.createText ("?", Frontend.mediumFont, Text.ALIGN_LEFT, x, y);
			y += 0.12;
		}

		osd.hideGroup( redefineGroup = osd.endGroup() );

		//-------game controller options menu--------------

		osd.createBG( RID_GENERALBG );
		osd.createHeader( "REDEFINE GAME CONTROLS" );

		m = osd.createMenu( butt0, -0.4, -0.6, 0 );

		m.addItem( "ACCESS MAIN MENU", CMD_GETKEY + 10 );
		m.addItem( "NEXT RADIO STATION", CMD_GETKEY + 11 );
		m.addItem( "PREV RADIO STATION", CMD_GETKEY + 12 );
		m.addItem( "VOLUME UP", CMD_GETKEY + 13 );
		m.addItem( "VOLUME DOWN", CMD_GETKEY + 14 );

		m = osd.createMenu( butt2, 0.98, 0.85, 0 );
		m.addItem( "BACK", CMD_REDEFINE_DONE );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_REDEFINE_DONE, this );

		x =  0.30;
		y = -0.63;
		for (int i = 10; i <= 14; i++)
		{
			keyText[i] = osd.createText ("?", Frontend.mediumFont, Text.ALIGN_LEFT, x, y);
			y += 0.12;
		}

		osd.hideGroup( redefine2Group = osd.endGroup() );

		//-------------advanced settings menu----------------

		powerSlider = new Slider[4];
		dzSlider = new Slider[4];
		ffbSlider = new Slider[2];

		osd.createBG( RID_GENERALBG );
		osd.createHeader( "ADVANCED CONTROL SETTINGS" );

		m = osd.createMenu( butt1, 0.0, -0.6, 0 );
		m.setSliderStyle( sld1, sldk );

		powerSlider[0] = m.addItem( "ACCEL. GAMMA", CMD_POWER + 0, 0.0, null );
		powerSlider[1] = m.addItem( "BRAKE GAMMA", CMD_POWER + 1, 0.0, null );
		powerSlider[2] = m.addItem( "STEERING GAMMA", CMD_POWER + 2, 0.0, null );
		powerSlider[3] = m.addItem( "CLUTCH GAMMA", CMD_POWER + 3, 0.0, null );

		m.addItem( "MOUSE SENSITIVITY", CMD_MOUSE_SENS, Config.mouseSensitivity, null );

		dzSlider[0] = m.addItem( "ACCELERATE DEAD ZONE", CMD_DEAD_ZONE + 0, 0.0, null );
		dzSlider[1] = m.addItem( "BRAKE DEAD ZONE", CMD_DEAD_ZONE + 1, 0.0, null );
		dzSlider[2] = m.addItem( "STEERING DEAD ZONE", CMD_DEAD_ZONE + 2, 0.0, null );
		dzSlider[3] = m.addItem( "CLUTCH DEAD ZONE", CMD_DEAD_ZONE + 3, 0.0, null );
		
		m.addSeparator();
		ffbSlider[0] = m.addItem( "REAL FFB STRENGTH", CMD_FFB + 0, Config.FFB_strength, 0.0f, 1.0f, 0, null );
		ffbSlider[1] = m.addItem( "EMULATED FFB STRENGTH", CMD_FFB + 1, Config.FFB_strength_emulated, 0.0f, 0.1f, 0, null );

		m = osd.createMenu( butt2, 0.98, 0.85, 0,  Osd.MD_HORIZONTAL );
		m.addItem( "BACK", CMD_REDEFINE_DONE );
		m.addItem( "CHECK AXES", CMD_AXISCHECK );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_REDEFINE_DONE, this );

		osd.hideGroup( redefine3Group = osd.endGroup() );

		//-------------axis checker menu----------------

		osd.createBG( RID_GENERALBG );
		osd.createHeader( "VIEW CONTROL AXES" );
		osd.createText( "Please review how the axes respond to the car controls:", Frontend.mediumFont, Text.ALIGN_LEFT, -0.95, -0.7 );

		Style sldac = new Style( 0.85, 0.06, Frontend.mediumFont, Text.ALIGN_CENTER, new ResourceRef(Osd.RID_SLD_BACK) );

		m = osd.createMenu( butt1, 0.0, -0.45, 0 );
		m.setSliderStyle( sldac, sldk );

		acGasSlider = m.addItem( "THROTTLE", CMD_UNUSED, 0.0, 0.0, 1.0, 0, null );
		acGasSlider.nofocus = 1;
		m.addSeparator();
		acBreakSlider = m.addItem( "BRAKE", CMD_UNUSED, 0.0, 0.0, 1.0, 0, null );
		acBreakSlider.nofocus = 1;
		m.addSeparator();
		acSteerSlider = m.addItem( "STEER", CMD_UNUSED, 0.5, 0.0, 1.0, 0, null );
		acSteerSlider.nofocus = 1;
		m.addSeparator();
		acClutchSlider = m.addItem( "CLUTCH", CMD_UNUSED, 0.5, 0.0, 1.0, 0, null );
		acClutchSlider.nofocus = 1;

		m = osd.createMenu( butt2, 0.98, 0.85, 0 );
		m.addItem( "BACK", CMD_AXISCHECK_DONE );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_AXISCHECK_DONE, this );

		osd.hideGroup( axisCheckGroup = osd.endGroup() );

		//-------------game options menu----------------

		osd.createBG( RID_GENERALBG );
		osd.createHeader( "GAME OPTIONS" );

		m = osd.createMenu( butt0, 0.0, -0.6, 0 );
		m.setSliderStyle( sld1, sldk );

		m.addItem( "TRANSMISSION", CMD_CLUTCH, clutchTrf[Config.player_transmission], clutchText, null );
		m.addItem( "METRIC SYSTEM", CMD_METRIC, Config.metricSystem, metricSystemText, null );
		m.addItem( "GPS MODE", CMD_GPSMODE, Config.gpsMode, gpsText, null );
		m.addItem( "DIFFICULTY LEVEL", CMD_DIFFICULTY, Config.deformation, 0.5, 1.5, 0, null );
		m.addSeparator();
		m.addItem( "STEERING HELP", CMD_STEERHELP, Config.player_steeringhelp, null );
		m.addItem( "ABS", CMD_ABS_SLIDER, Config.player_abs, null );
		m.addItem( "ASR", CMD_ASR_SLIDER, Config.player_asr, null );

		m = osd.createMenu( butt2, 0.98, 0.85, 0 );
		m.addItem( "BACK", CMD_GAME_OPTIONS_DONE );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_GAME_OPTIONS_DONE, this );
		osd.hideGroup( gameGroup = osd.endGroup() );

		//-------------game options 2 menu----------------

		osd.createBG( RID_GENERALBG );
		osd.createHeader( "ADVANCED GAME OPTIONS" );

		m = osd.createMenu( butt0, 0.0, -0.6, 0 );
		m.setSliderStyle( sld1, sldk );

		m.addItem( "DRIVER MOVEMENT/STEER", CMD_HMF_1, Config.head_move_steer, 0.0, 2.0, 0, "HOW THE STEERING WHEELS POSITION AFFECTS THE DRIVERS MOVEMENT" );
		m.addItem( "DRIVER MOVEMENT/VELOCITY", CMD_HMF_2, Config.head_move_vel, 0.0, 2.0, 0, "HOW THE CARS VELOCITY AFFECTS THE DRIVERS MOVEMENT"  );
		m.addItem( "DRIVER MOVEMENT/ACCELERATION", CMD_HMF_3, Config.head_move_acc, 0.0, 2.0, 0, "HOW THE CARS ACCELERATION AFFECTS THE DRIVERS MOVEMENT"  );
		m.addSeparator();
		m.addItem( "TRAFFIC DENSITY", CMD_TRAFFICDENSITY, Config.trafficDensity, 0.0, 1.5, 0, null );
		m.addItem( "PEDESTRIAN DENSITY", CMD_PEDESTRIANDENSITY, Config.pedestrianDensity, 0.0, 1.5, 0, null );

		m = osd.createMenu( butt2, 0.98, 0.85, 0 );
		m.addItem( "BACK", CMD_GAME_OPTIONS_DONE );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_GAME_OPTIONS_DONE, this );
		osd.hideGroup( game2Group = osd.endGroup() );

		super.show();

		enableAnimateHook();
	}

	public void hide()
	{
		disableAnimateHook();
		super.hide();
	}


	public void addCustomGroups()
	{
	}


//--------------------------------------------------------------------------------------
	public void setDetailText( Text txt, int detail )
	{
		if( detail == Config.OFF )
			txt.changeText( "Off" );
		else
		if( detail == Config.LOW )
			txt.changeText( "Low" );
		else
		if( detail == Config.MID )
			txt.changeText( "Mid" );
		else
		if( detail == Config.HIGH )
			txt.changeText( "High" );
	}

	public void setEnabledText( Text txt, int enabled )
	{
		if( enabled == 0 )
			txt.changeText( "Disabled" );
		else
			txt.changeText( "Enabled" );
	}

	public int ChangeDetail (int value, int delta, int min, int max)
	{
		value += delta;
		if( value < min )
			value = max;
		if( value > max )
			value = min;
		return value;
	}

	public int fequal( float v1, float v2 )
	{
		float d = v1 - v2;
		if( d < 0 )
			d = -d;
		if( d < 0.001 )
			return 1;

		return 0;
	}

	public void osdCommand (int command)
	{
		if (command < 0)
			return;
		else
		if (command == CMD_AXISCHECK)
		{
			axisCheckCallerGroup = actGroup;
			changeMode (axisCheckGroup);

			//a redefine menuk -ahonnan mi elerhetoek vagyunk- mar beallitottak, de meg nem mentettek a beallitasokat
			player.controller.setcontrol( controlSet );
		}
		else
		if (command == CMD_AXISCHECK_DONE)
		{
			changeMode (axisCheckCallerGroup);
		}
		else
		if (command == CMD_EFFECTS_VOL)
		{
			Sound.setVolume ( Sound.CHANNEL_EFFECTS, osd.sliderValue );
		}
		else
		if (command == CMD_MUSIC_VOL)
		{
			Sound.setVolume ( Sound.CHANNEL_MUSIC, osd.sliderValue );
		}
		else
		if (command == CMD_ENGINE_VOL)
		{
			Sound.setVolume ( Sound.CHANNEL_ENGINE, osd.sliderValue );
		}
		else
		if (command == CMD_OPTIONS)
		{
			changeMode (optionsGroup);
		}
		else
		if (command == CMD_VIDEO_OPTIONS)
		{
			changeMode (videoGroup);
		}
		else
		if (command == CMD_VIDEO_OPTIONS_DONE)
		{
			if( textureDetail == Config.HIGH )
			{
				Config.texture_size = Config.texture_size_high;
				Config.shadow_size = Config.shadow_size_high;
			}
			else if( textureDetail == Config.MID )
			{
				Config.texture_size = Config.texture_size_mid;
				Config.shadow_size = Config.shadow_size_mid;
			}
			else
			{
				Config.texture_size = Config.texture_size_low;
				Config.shadow_size = Config.shadow_size_low;
			}


			if( shadowDetail == Config.HIGH )
			{
				Config.shadows = Config.shadows_high;
				Config.shadow_detail = Config.shadow_detail_high;
			}
			else if( shadowDetail == Config.MID )
			{
				Config.shadows = Config.shadows_mid;
				Config.shadow_detail = Config.shadow_detail_mid;
			}
			else if( shadowDetail == Config.LOW )
			{
				Config.shadows = Config.shadows_low;
				Config.shadow_detail = Config.shadow_detail_low;
			}
			else
			{
				Config.shadows = Config.shadows_off;
				Config.shadow_detail = Config.shadow_detail_off;
		//		Config.shadow_size = Config.shadow_size_off;
			}

			System.getConfigOptions();

			if( lastVideoMode != videoMode )
			{
				lastVideoMode = videoMode;

				VideoMode vms = videoModes.elementAt(videoMode);

				Config.video_x=vms.width;
				Config.video_y=vms.height;
				Config.video_depth=vms.depth;
				Config.video_windowed=vms.windowed;

				GfxEngine.changeVideoMode( vms.width, vms.height, vms.depth );

				Frontend.rebuild();
			}

			changeMode (optionsGroup);
		}
		else
		if (command == CMD_RESOLUTION)
		{
			videoMode =  osd.multiValue;
		}
		else
		if (command == CMD_TEXTURE_DETAIL)
		{
			textureDetail = osd.multiValue;
		}
		else
		if (command == CMD_ABS_SLIDER)
		{
			Config.player_abs = osd.sliderValue;
		}
		else
		if (command == CMD_ASR_SLIDER)
		{
			Config.player_asr = osd.sliderValue;
		}
		else
		if (command == CMD_HMF_1)
		{
			Config.head_move_steer = osd.sliderValue;
		}
		else
		if (command == CMD_HMF_2)
		{
			Config.head_move_vel = osd.sliderValue;
		}
		else
		if (command == CMD_HMF_3)
		{
			Config.head_move_acc = osd.sliderValue;
		}
		else
		if (command == CMD_SHADOW_DETAIL)
		{
			shadowDetail = osd.multiValue-1;
			//CMD_VIDEO_OPTIONS_DONE hatasara lep ervenybe!
			//refreshCameras();
		}
		else
		if (command == CMD_FLARES)
		{
			Config.flares = osd.multiValue;
			refreshCameras();
		}
		else
		if (command == CMD_HEADLIGHTS)
		{
			Config.headlight_rays = osd.multiValue;
			refreshCameras();
		}
		else
		if (command == CMD_VIEW_RANGE)
		{
			Config.camera_ext_viewrange = osd.sliderValue;
			Config.camera_int_viewrange = osd.sliderValue;
			refreshCameras();
		}
		else
		if (command == CMD_OBJECT_DETAIL)
		{
			Config.object_detail = osd.sliderValue;
			refreshCameras();
		}
		else
		if (command == CMD_LOD_DETAIL)
		{
			Config.object_detail_amp = osd.sliderValue;
			refreshCameras();
		}
		else
		if (command == CMD_PARTICLE)
		{
			Config.particle_density = osd.sliderValue;
			refreshCameras();
		}
		else
		if (command == CMD_GAMMA)
		{
			Config.video_gamma = osd.sliderValue;
			refreshCameras();
		}
		else
		if (command == CMD_CONTROL_OPTIONS)
		{
			changeMode (controlGroup);
		}
		else
		if (command == CMD_GAME_OPTIONS)
		{
			changeMode (gameGroup);
		}
		else
		if (command == CMD_GAME_OPTIONS2)
		{
			changeMode (game2Group);
		}
		else
		if (command == CMD_GPSMODE)
		{
			Config.gpsMode = osd.multiValue;
		}
		if (command == CMD_METRIC)
		{
			Config.metricSystem = osd.multiValue;		// miles, kilometers, 
			if( Config.metricSystem == 0 )
				System.setMeasure( 1600 );
			else
				System.setMeasure( 1000 );
		}
		else
		if (command == CMD_DIFFICULTY)
		{
			Config.deformation = osd.sliderValue;
			Config.internal_damage = osd.sliderValue;
			Config.player_damage_multiplier = osd.sliderValue / 2.0;
		}
		else
		if (command == CMD_TRAFFICDENSITY)
		{
			Config.trafficDensity = osd.sliderValue;
		}
		else
		if (command == CMD_PEDESTRIANDENSITY)
		{
			Config.pedestrianDensity = osd.sliderValue;
		}
		else
		if (command == CMD_CLUTCH)
		{
			Config.player_transmission = clutchTrfInv[osd.multiValue];
		}
		else
		if (command == CMD_STEERHELP)
		{
			Config.player_steeringhelp = osd.sliderValue;
		}
		else
		if (command == CMD_GAME_OPTIONS_DONE)
		{
			System.getConfigOptions();
			changeMode (optionsGroup);
		}
		else
		if (command == CMD_SOUND_OPTIONS)
		{
			//lehetseges modeok, es kijelzesuk
			//MIX	OFF	ON	ON	AUTO
			//3D	OFF	OFF	ON	AUTO
			//		OFF	2D	3D	AUTO

			int soundHW = Config.Sound_Mix_HW;
			if( soundHW == 2 )
				soundHW++;
			if( Config.Sound_Mix_HW == 1 && Config.Sound_3D_HW == 1 )
				soundHW++;

			soundHWMulti.setValue( soundHW );

			changeMode (soundGroup);
		}
		else
		if (command == CMD_SOUND_HW)
		{
			switch( osd.multiValue )
			{
			case 0:
				Config.Sound_Mix_HW = 0;
				Config.Sound_3D_HW = 0;
				break;
			case 1:
				Config.Sound_Mix_HW = 1;
				Config.Sound_3D_HW = 0;
				break;
			case 2:
				Config.Sound_Mix_HW = 1;
				Config.Sound_3D_HW = 1;
				break;
			case 3:
				Config.Sound_Mix_HW = 2;
				Config.Sound_3D_HW = 2;
				break;
			}
			//TODO: tell the sound engine to apply the changes
		}
		else
		if (command == CMD_MAIN)
		{
			changeMode (mainGroup);
		}
		else
		if (command == CMD_REDEFINE_CONTROLS || command == CMD_REDEFINE_CONTROLS2 || command == CMD_REDEFINE_CONTROLS3)
		{
			int	i;

			controlSet = new ControlSet();
			controlSet.load( GameLogic.activeControlFile );

			for( int i = 0; i < NCONTROLS; i++ )
			{
				if (controlSet.deviceID[i] < 0 || controlSet.axisID[i] < 0)
					keyText[i].changeText( "Undefined" );
				else
					keyText[i].changeText( Input.axisName (controlSet.deviceID[i], controlSet.axisID[i]) );
			}

			powerSlider[0].setValue( (controlSet.vasp.elementAt(0).power - 1.0) / 4.0 );	// value: 1.0..5.0
			powerSlider[1].setValue( (controlSet.vasp.elementAt(1).power - 1.0) / 4.0 );
			powerSlider[2].setValue( (controlSet.vasp.elementAt(2).power - 1.0) / 4.0 );
			powerSlider[3].setValue( (controlSet.vasp.elementAt(3).power - 1.0) / 4.0 );

			dzSlider[0].setValue( controlSet.dead_zone[0] / 0.2 );							// value: 0.0..0.2
			dzSlider[1].setValue( controlSet.dead_zone[1] / 0.2 );
			dzSlider[2].setValue( controlSet.dead_zone[2] / 0.2 );
			dzSlider[3].setValue( controlSet.dead_zone[7] / 0.2 );

			if (command == CMD_REDEFINE_CONTROLS)
				changeMode (redefineGroup);
			else if (command == CMD_REDEFINE_CONTROLS2)
				changeMode (redefine2Group);
			else
				changeMode (redefine3Group);
		}
		else
		if (command == CMD_REDEFINE_DONE)
		{
			controlSet.save( GameLogic.activeControlFile );
			changeMode (controlGroup);
		}
		else
		if (command == CMD_RESET_CONTROLS)
		{
			controlSet = new ControlSet();
			controlSet.save( GameLogic.activeControlFile );
			player.controller.setcontrol( controlSet );
		}
		else
		if (command == CMD_LOAD_CONTROLS)
		{
			ControlsFileReqDialog d = new ControlsFileReqDialog( player.controller, Dialog.DF_MODAL|Dialog.DF_DEFAULTBG, "LOAD CONTROL DEFINITIONS", "LOAD CONTROLS", GameLogic.controlSaveDir, "*" );

			if( d.display() == 0 )
			{
				String filename = GameLogic.controlSaveDir + d.fileName;

				controlSet = new ControlSet();
				controlSet.load( filename );
				controlSet.save( GameLogic.activeControlFile );
				player.controller.setcontrol( controlSet );
			}
		}
		else
		if (command == CMD_SAVE_CONTROLS)
		{
			ControlsFileReqDialog d = new ControlsFileReqDialog( player.controller, Dialog.DF_MODAL|Dialog.DF_DEFAULTBG|Dialog.FRF_SAVE, "SAVE CONTROL DEFINITIONS", "SAVE CONTROLS", GameLogic.controlSaveDir, "*" );

			if( d.display() == 0 )
			{
				String filename = GameLogic.controlSaveDir + d.fileName;

				if( File.exists( GameLogic.activeControlFile ) )
				{
					File.copy( GameLogic.activeControlFile, filename );
				}
				else
				{	//elso inditas, meg nem letezik a file!!
					controlSet = new ControlSet();
					controlSet.save( filename );
				}
			}
		}
		else
		if (command >= CMD_GETKEY && command < CMD_GETKEY + NCONTROLS)
		{
			if (getKey == -1)
			{
				getKey = command - CMD_GETKEY;
				keyText[getKey].changeText("_");
				getKeyStat = 0;
				// special request: reset mouse and set sensitivity
				Input.getAxis (1, -1 - (Config.mouseSensitivity * 100.0f));
			}
		}
		else
		if (command >= CMD_DEAD_ZONE && command < CMD_DEAD_ZONE + 4)
		{
			int		dz;

			dz = command - CMD_DEAD_ZONE;	// remap 0,1,2,3 -> 0,1,2,7
			if (dz == 3)
			{
				dz = 7;
			}
			controlSet.dead_zone[dz] = osd.sliderValue * 0.2f;
			controlSet.dead_zone[dz + 15] = osd.sliderValue * 0.2f;
			player.controller.setcontrol( controlSet );
		}
		else
		if (command >= CMD_POWER && command < CMD_POWER + 4)
		{
			float pow = 1.125 + 4.0 * osd.sliderValue;
			int ipower = pow * 4;
			pow = ipower;
			pow = pow / 4.0;
			controlSet.vasp.elementAt( command - CMD_POWER ).power = pow;
			player.controller.setcontrol( controlSet );
		}
		else
		if (command == CMD_FFB + 0)
		{
			Config.FFB_strength = osd.sliderValue;
			System.getConfigOptions();
		} 
		else
		if (command == CMD_FFB + 1)
		{
			Config.FFB_strength_emulated = osd.sliderValue;
			System.getConfigOptions();
		} 
		else
		if (command == CMD_MOUSE_SENS)
		{
			Config.mouseSensitivity = osd.sliderValue;
			if (Config.mouseSensitivity < 0.1)
				Config.mouseSensitivity = 0.1;
			// special request: reset mouse and set sensitivity
			Input.getAxis (1, -1 - (Config.mouseSensitivity * 100.0f));
			//send command to cursor
			Input.cursor.config();
		}
	}

	public void changeMode(int group)
	{
		if( actGroup != group )
		{
			if (actGroup >= 0)
			{
				osd.hideGroup (actGroup);
			}

			actGroup = group;

			osd.showGroup (actGroup);

			osd.changeSelection2( -1, 0 );
		}
	}


	public void animate()
	{
		//control remapper
		if (actGroup == redefineGroup || actGroup == redefine2Group)
		{
			if (getKey >= 0 && getKey < NCONTROLS)
			{
				int		device;
				int		axis = -1;

				for( device = 0; device < controlSet.nDevices; device++ )
				{
					axis = Input.activeAxis (device);
					if( axis >= 0 )
						break;
				}

				if (getKeyStat == 0) 
				{
					if (axis < 0) 
					{
						getKeyStat = 1;
					}
				} 
				else 
				if (getKeyStat == 1)
				{
					if (axis >= 0) 
					{
						float val = Input.getAxis (device, axis);
						keyText[getKey].changeText (Input.axisName (device, axis));
						controlSet.change( getKey, device, axis);
						int i;
						for (i = 0; i < NCONTROLS; i++) 
						{
							if (i != getKey && controlSet.deviceID [i] == device && controlSet.axisID [i] == axis)
								break;
						}
						if (device == 0 || val > 0.95f) {
							controlSet.from_min [getKey] = 0.0f;
							controlSet.from_max [getKey] = 1.0f;
						} 
						else 
						{
							if (i < NCONTROLS) 
							{
								if (val < 0.0f) 
								{
									controlSet.from_min [getKey] = 0.0f;
									controlSet.from_max [getKey] = -1.0f;
									controlSet.from_min [i] = 0.0f;
									controlSet.from_max [i] = 1.0f;
								} 
								else 
								{
									controlSet.from_min [getKey] = 0.0f;
									controlSet.from_max [getKey] = 1.0f;
									controlSet.from_min [i] = 0.0f;
									controlSet.from_max [i] = -1.0f;
								}
							} 
							else 
							{
								controlSet.from_min [getKey] = -1.0f;
								controlSet.from_max [getKey] = 1.0f;
							}
						}
						player.controller.setcontrol( controlSet );
						getKeyStat = 2;
					}
				} 
				else 
				{
					if (axis < 0) 
					{
						getKey = -1;
					}
				}
			}
		}

		//gas/brake/steer axis position updater
		if (actGroup == axisCheckGroup)
		{
			acGasSlider.setValue( Input.getInput( Input.AXIS_THROTTLE ) / 128.0 );
			acBreakSlider.setValue( Input.getInput( Input.AXIS_BRAKE ) / 128.0 );
			acSteerSlider.setValue( Input.getInput( Input.AXIS_TURN_LEFTRIGHT ) / -256.0 + 0.5);
			acClutchSlider.setValue( Input.getInput( Input.AXIS_CLUTCH ) / 128.0);
		}
	}


	GameRef activeCamera;

	public void refreshCameras()
	{
		System.getConfigOptions();

		//mega patchek:
		//( a fenti hivasnak kellene triggerelni minden aktiv 3d-engine kamerat, nem itt vacakolni veluk!!!)
		if( activeCamera )
			activeCamera.command( "render 0" );

		if (GameLogic.player && GameLogic.player.car )
			GameLogic.player.car.command( "render 0 "+ GameLogic.player.controller.id() );

	}

	public void setActiveCamera( GameRef cam )
	{
		activeCamera = cam;
	}

}


class ControlsFileReqDialog extends FileRequesterDialog
{
	public ControlsFileReqDialog( Controller ctrl, int myflags, String mytitle, String OKButtonText, String path, String mask )
	{
		super( ctrl, myflags, mytitle, OKButtonText, path, mask );
		if( myflags & FRF_SAVE )
			osd.defSelection = 5;
	}

	public int validator( String filename )
	{
		return ControlSet.fileCheck( filename );
	}
}
