package java.game;

import java.io.*;
import java.util.*;
import java.util.resource.*;
import java.render.*;
import java.render.osd.*;
import java.render.osd.dialog.*;
import java.sound.*;

import java.game.parts.*;

public class Catalog extends GameType implements GameState
{
	final static ResourceRef RR_ICON_CAR_COMP = new ResourceRef( misc.catalog:0x0004r );
	final static ResourceRef RR_ICON_CAR_1STEP = new ResourceRef( misc.catalog:0x0005r );
	final static ResourceRef RR_ICON_INV_COMP = new ResourceRef( misc.catalog:0x0007r );


	final static int DECALPRICE = 20;

	final static int SC_ENGINE	= 0;
	final static int SC_BODY	= 1;
	final static int SC_RGEAR	= 2;
	final static int SC_NONE	= 3;	//max+1

	final static int CMD_EXIT  = 0;
	final static int CMD_FRONTPAGE = 1;
	final static int CMD_MAIN1 = 2;
	final static int CMD_MAIN2 = 3;
	final static int CMD_MAIN3 = 4;
	final static int CMD_MAIN4 = 5;
	final static int CMD_MAIN5 = 6;
	final static int CMD_MAIN6 = 7;

	final static int CMD_MAIN1_1 = 8;
	final static int CMD_MAIN1_2 = 9;
	final static int CMD_MAIN1_3 =10;
	final static int CMD_MAIN1_4 =11;
	final static int CMD_MAIN1_5 =12;
	final static int CMD_MAIN1_6 =13;
	final static int CMD_MAIN1_7 =14;

	final static int CMD_MAIN2_1 =15;
	final static int CMD_MAIN2_2 =16;
	final static int CMD_MAIN2_3 =17;
	final static int CMD_MAIN2_4 =18;
	final static int CMD_MAIN2_5 =19;
	final static int CMD_MAIN2_6 =20;
	final static int CMD_MAIN2_7 =21;

	final static int CMD_MAIN3_1 =22;
	final static int CMD_MAIN3_2 =23;
	final static int CMD_MAIN3_3 =24;
	final static int CMD_MAIN3_4 =25;
	final static int CMD_MAIN3_5 =26;
	final static int CMD_MAIN3_6 =27;
	final static int CMD_MAIN3_7 =28;

	final static int CMD_MAIN4_1 =29;
	final static int CMD_MAIN4_2 =30;
	final static int CMD_MAIN4_3 =31;
	final static int CMD_MAIN4_4 =32;
	final static int CMD_MAIN4_5 =33;
	final static int CMD_MAIN4_6 =34;
	final static int CMD_MAIN4_7 =35;
	final static int CMD_MAIN4_8 =36;

	final static int CMD_MAIN5_1 =37;
	final static int CMD_MAIN5_2 =38;
	final static int CMD_MAIN5_3 =39;
	final static int CMD_MAIN5_4 =40;
	final static int CMD_MAIN5_5 =41;
	final static int CMD_MAIN5_6 =42;

	final static int CMD_MAIN6_1 =43;
	final static int CMD_MAIN6_2 =44;
	final static int CMD_MAIN6_3 =45;
	final static int CMD_MAIN6_4 =46;
	final static int CMD_MAIN6_5 =47;
	final static int CMD_MAIN6_6 =48;
	final static int CMD_MAIN6_7 =49;


	final static int CMD_DB0 =50;
	final static int CMD_DB1 =51;
	final static int CMD_DB2 =52;
	final static int CMD_DB3 =53;
	final static int CMD_DB4 =54;
	final static int CMD_DB5 =55;
	final static int CMD_DB6 =56;
	final static int CMD_DB7 =57;

	final static int CMD_PREVDECALPAGE =58;
	final static int CMD_NEXTDECALPAGE =59;

	final static int CMD_PREVPARTPAGE =60;
	final static int CMD_NEXTPARTPAGE =61;


	final static String pageNumberPrefix;

	final static float PRICERATIO = 1.1;	//katalogus ar-szorzo

	Player			player;

	Osd				osd;

	int				actGroup;

	Text			moneytxt, pgNumberL, pgNumberR;
	Text[]			pageNumberL = new Text[6];
	Text[]			pageNumberR = new Text[6];

	CatalogInventory	inventory;
	Vector			collector;

	int				curpage=1;

	int				currentCarPackId, partsPackId;

	Decal[]			curDecals;
	Button[]		decalButtons;
	Vector			decals;
	int				showDecals;

	int				mainGroup, main1Group, main2Group, main3Group, main4Group, main5Group, main6Group;
	int				decalsGroup, parts1Group, parts2Group, parts3Group, parts4Group, parts5Group;

	ResourceRef[]	carTypes;

	public Catalog()
	{
		createNativeInstance();

		player = GameLogic.player;

		carTypes = GameLogic.VEHICLETYPE_ROOT.getChildNodes();
	}

	public static Vector collectDecals( String subdir )
	{
		Vector ds = new Vector();

		FindFile ff = new FindFile();
		String name=ff.first( "decals/textures/catalog/" + subdir + "/*.png" );
		while( name )
		{
			Decal decal = new Decal( "decals/textures/catalog/" +subdir + "/" + name );	//extends ResourceRef
			ds.addElement( decal );
			name = ff.next();
		}
		ff.close();

		return ds;
	}

	public void clearObjectCache()
	{
		if( inventory )
		{
			inventory.hide();
			inventory.flushAll();
			inventory = null;
		}

		collector = null;
	}

	//puts parts of the given category and car type (+common parts) to the given inventory
	public void collectObjectsBegin()
	{
		clearObjectCache();

		inventory = new CatalogInventory( this, player, 0.02, 0.25, 0.96, 0.50 );
		collector = new Vector();

		if( player.car )
			currentCarPackId = player.car.getInfo( GII_TYPE ) >> 16;
		else
			currentCarPackId = 0;

		partsPackId = System.openLib( "parts.rpk" );
	}

	public void collectObjectsEnd()
	{
		collectObjectsStep(9);

		inventory.update();
		inventory.show();
	}
	
	public void collectObjects( GameRef root )
	{
		Vector stack = collector;

		if( root )
		{
			stack.addElement( root );
		}
	}

	//return false if finished collecting
	public int collectObjectsStep( int step )
	{
		Inventory destination = inventory;
		Vector stack = collector;

		GameRef parts;

		if( stack )
		{
			while( !stack.isEmpty() && step )
			{
				parts=stack.removeLastElement();

				if( parts.isScripted( "java.game.parts.Part" ) )	//alkatresz?
				{
					//destination.addItem( parts );
					//destination.addItem( parts.id() );	//tipus id alapjan instanceot hoz letre
					destination.items.addElement( new InventoryItem_Part( destination, parts.id() ) );	//az update hivast megsporoljuk :)

					step--;
				}
				else
				if( parts.isScripted( "java.game.parts.Set" ) )	//set?
				{
					Set set = parts.create( null, parts, null, "set_loader" );

					InventoryItem_Folder tmp = new InventoryItem_Folder( destination );
					tmp.set = set;
					set.build( tmp.inv );
					destination.items.addElement( tmp ); 
				}
				else
				{	//dummy eloszto node!
					
					//vegigszkenneljuk a tartalmat:
					//a lonely partok, parts dummy alattiak es aktualis kocsi alattiak menek tovabi feldolgozasra
					//a mas kocsik dummyjai alattiak nem jelennek meg!
					if( parts=parts.getFirstChild() )
					{
						while( parts )
						{
							if( parts.isScripted() )
								stack.addElement( parts );
							else
							{
								int	carPack;
								int packId = parts.id() >> 16;
	
								/*old
								if( packId == partsPackId || packId == currentCarPackId )
									stack.addElement( parts );
								*/

								//new
								for( int i=carTypes.length-1; i>=0; i-- )
								{
									if( packId == carTypes[i].id()>>16 )
									{
										carPack=1;
										break;
									}
								}
								
								if( !carPack || packId == currentCarPackId )
									stack.addElement( parts );
								//
							}

							parts=parts.getNextChild();
						}
					}
				}
			}

			destination.update();

			return !stack.isEmpty();
		}

		return 0;
	}


	public void setDecalButtons()
	{
		int	max = decals.size();

		clearDecalButtons();

		for( int i=0; i<decalButtons.length; i++ )
		{
			//a gomb tipus (nagy)
			RenderRef	base = new RenderRef( frontend:0x00AEr );
	
			if( max > showDecals+i )
			{
				curDecals[i] = decals.elementAt( showDecals+i );
				decalButtons[i].rect.changeTexture( decals.elementAt( showDecals+i ) );
			}
		}
	}

	public void clearDecalButtons()
	{
		for( int i=0; i<decalButtons.length; i++ )
		{
			decalButtons[i].rect.changeTexture( Osd.RRT_EMPTY );
			if( curDecals[i] )
			{
				curDecals[i].unload();
				curDecals[i] = null;
			}
		}
	}

	public void enter( GameState prev_state )
	{
		osd = new Osd();
		osd.globalHandler = this;

		showDecals=0;

		setEventMask( EVENT_TIME );

		createOSDObjects();
		osd.show();

		Input.cursor.enable(1);
		setEventMask( EVENT_CURSOR );
	}

	public void exit( GameState next_state )
	{
		Frontend.loadingScreen.hide();

		clearEventMask( EVENT_ANY );
		removeAllTimers();
		Input.cursor.enable(0);

		pageNumberPrefix=null;

		osd.hide();
	}

	public void createOSDObjects()
	{
		Style bsm = new Style( 0.70, 0.13, Frontend.largeFont, Text.ALIGN_RIGHT, Osd.RRT_TEST );
		Style bs = new Style( 0.70, 0.13, Frontend.mediumFont, Text.ALIGN_RIGHT, Osd.RRT_TEST );
		
		Style bbsr = new Style( 0.12, 0.12, 1.0, Frontend.mediumFont, Text.ALIGN_RIGHT, new ResourceRef(Osd.RID_ARROWRG) );
		Style bbsl = new Style( 0.12, 0.12, 1.0, Frontend.mediumFont, Text.ALIGN_LEFT, new ResourceRef(Osd.RID_ARROWLF) );

		Style bex = new Style( 0.12, 0.12, 1.0, Frontend.mediumFont, Text.ALIGN_CENTER, new ResourceRef(Osd.RID_EXIT) );
		Style bek = new Style( 0.12, 0.12, 1.0, Frontend.mediumFont, Text.ALIGN_CENTER, new ResourceRef(Osd.RID_BACK) );

		Menu m;

		//always visible objects:
		moneytxt=osd.createText( null, Frontend.mediumFont, Text.ALIGN_CENTER,	0.50, -0.95 );
		osd.endGroup();

		//----------------------------------------Grand Index

		osd.createBG( new ResourceRef(misc.catalog:0x0006r) );

		m= osd.createMenu( bsm, 1.0, -0.55, 0.2 );
		m.addItem( "ENGINE", CMD_MAIN1 );
		m.addItem( "BODY", CMD_MAIN2 );
		m.addItem( "RUNNING GEAR", CMD_MAIN3 );
		m.addItem( "INTERIOR", CMD_MAIN4 );
		if(Config.enable_audio_section)
			m.addItem( "AUDIO", CMD_MAIN5 );
		m.addItem( "DECALS", CMD_MAIN6 );
		
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_EXIT, this );
		actGroup = mainGroup = osd.endGroup();

		//----------------------------------------Engine Index

		osd.createBG( new ResourceRef(misc.catalog:0x0009r) );

		m= osd.createMenu( bs, 1.0, -0.55, 0.18 );
		m.addItem( "MAIN COMPONENTS", CMD_MAIN1_1 );
		m.addItem( "AIR&FUEL DELIVERY", CMD_MAIN1_2 );
		m.addItem( "EXHAUST", CMD_MAIN1_3 );
		m.addItem( "TRANSMISSION & DRIVETRAIN", CMD_MAIN1_4 );
		m.addItem( "ACCESSORIES & OTHERS", CMD_MAIN1_5 );
		m.addItem( "PRO TUNING", CMD_MAIN1_6 );
		m.addItem( "ENGINE KITS", CMD_MAIN1_7 );
		
		osd.createButton( bek, 0.08, -0.92, CMD_FRONTPAGE, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_FRONTPAGE, this );
		osd.hideGroup( main1Group = osd.endGroup() );

		//----------------------------------------Body Index

		osd.createBG( new ResourceRef(misc.catalog:0x0010r) );

		m= osd.createMenu( bs, 1.0, -0.55, 0.18 );
		m.addItem( "BODY PANELS", CMD_MAIN2_1 );
		//m.addItem( "REPLACEMENT PARTS", CMD_MAIN2_2 );
		m.addItem( "LIGHTS & WINDOWS", CMD_MAIN2_3 );
		//m.addItem( "REPLACEMENT LIGHTS & WINDOWS", CMD_MAIN2_4 );
		m.addItem( "AERODYNAMIC TUNING", CMD_MAIN2_5 );
		//m.addItem( "DECORATIVE PARTS", CMD_MAIN2_6 );
		m.addItem( "BODY KITS", CMD_MAIN2_7 );
		
		osd.createButton( bek, 0.08, -0.92, CMD_FRONTPAGE, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_FRONTPAGE, this );
		osd.hideGroup( main2Group = osd.endGroup() );

		//----------------------------------------Running Gear Index

		osd.createBG( new ResourceRef(misc.catalog:0x0011r) );

		m= osd.createMenu( bs, 1.0, -0.55, 0.18 );
		m.addItem( "SUSPENSIONS", CMD_MAIN3_1 );
		m.addItem( "SHOCKS & SPRINGS & BARS", CMD_MAIN3_2 );
		m.addItem( "BRAKE SYSTEMS", CMD_MAIN3_3 );
		m.addItem( "FACTORY WHEELS, RIMS", CMD_MAIN3_4 );
		m.addItem( "AFTERMARKET WHEELS, RIMS", CMD_MAIN3_5 );
		m.addItem( "TYRES", CMD_MAIN3_6 );
//		m.addItem( "RUNNING GEAR KITS", CMD_MAIN3_7 );
		
		osd.createButton( bek, 0.08, -0.92, CMD_FRONTPAGE, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_FRONTPAGE, this );
		osd.hideGroup( main3Group = osd.endGroup() );

		//----------------------------------------Interior Index

		osd.createBG( new ResourceRef(misc.catalog:0x001Er) );

		m= osd.createMenu( bs, 1.0, -0.55, 0 );
		m.addItem( "STEERING WHEELS", CMD_MAIN4_1 );
	//	m.addItem( "DASHES", CMD_MAIN4_2 );
	//	m.addItem( "GEAR KNOBS", CMD_MAIN4_3 );
	//	m.addItem( "PEDALS", CMD_MAIN4_4 );
	//	m.addItem( "GAUGES", CMD_MAIN4_5 );
		m.addItem( "SEATS", CMD_MAIN4_6 );
	//	m.addItem( "EXTRAS", CMD_MAIN4_7 );
	//	m.addItem( "DECORATION", CMD_MAIN4_8 );
		
		osd.createButton( bek, 0.08, -0.92, CMD_FRONTPAGE, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_FRONTPAGE, this );
		osd.hideGroup( main4Group = osd.endGroup() );

		//----------------------------------------Audio Index

		osd.createBG( new ResourceRef(misc.catalog:0x001Fr) );

		m= osd.createMenu( bs, 1.0, -0.55, 0.2 );
		m.addItem( "HEAD UNITS", CMD_MAIN5_1 );
		m.addItem( "AMPLIFIERS", CMD_MAIN5_2 );
		m.addItem( "BOXES", CMD_MAIN5_3 );
		m.addItem( "SUBWOOFERS", CMD_MAIN5_4 );
		m.addItem( "ACCESSORIES", CMD_MAIN5_5 );
		m.addItem( "AUDIO KITS", CMD_MAIN5_6 );
		
		osd.createButton( bek, 0.08, -0.92, CMD_FRONTPAGE, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_FRONTPAGE, this );
		osd.hideGroup( main5Group = osd.endGroup() );

		//----------------------------------------Decal Index

		osd.createBG( new ResourceRef(misc.catalog:0x0022r) );

		m= osd.createMenu( bs, 1.0, -0.55, 0.18 );
		m.addItem( "MANUFACTURERS", CMD_MAIN6_1 );
		m.addItem( "LOGOS", CMD_MAIN6_2 );
		m.addItem( "NUMBERS", CMD_MAIN6_3 );
		m.addItem( "DIGITS", CMD_MAIN6_4 );
		m.addItem( "SMILIES", CMD_MAIN6_5 );
		m.addItem( "ANIMALS", CMD_MAIN6_6 );
		m.addItem( "MISC", CMD_MAIN6_7 );
		
		osd.createButton( bek, 0.08, -0.92, CMD_FRONTPAGE, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_FRONTPAGE, this );
		osd.hideGroup( main6Group = osd.endGroup() );

		//----------------------------------------Akatreszlista oldalak 1

		osd.createBG( new ResourceRef(misc.catalog:0x0009r) );

		pageNumberL[0] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_LEFT,	-0.96,  0.82);
		pageNumberR[0] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_RIGHT,	0.96,  0.82);

		osd.createButton( bbsl, -0.96, 0.92, CMD_PREVPARTPAGE, null );
		osd.createButton( bbsr, 0.96, 0.92, CMD_NEXTPARTPAGE, null );

		osd.createButton( bek, 0.08, -0.92, CMD_MAIN1, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_MAIN1, this );
		osd.hideGroup( parts1Group = osd.endGroup() );

		//----------------------------------------Akatreszlista oldalak 2
		osd.createBG( new ResourceRef(misc.catalog:0x0010r) );

		pageNumberL[1] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_LEFT,	-0.96,  0.82);
		pageNumberR[1] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_RIGHT,	0.96,  0.82);

		osd.createButton( bbsl, -0.96, 0.92, CMD_PREVPARTPAGE, null );
		osd.createButton( bbsr, 0.96, 0.92, CMD_NEXTPARTPAGE, null );

		osd.createButton( bek, 0.08, -0.92, CMD_MAIN2, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_MAIN2, this );
		osd.hideGroup( parts2Group = osd.endGroup() );

		//----------------------------------------Akatreszlista oldalak 3
		osd.createBG( new ResourceRef(misc.catalog:0x0011r) );

		pageNumberL[2] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_LEFT,	-0.96,  0.82);
		pageNumberR[2] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_RIGHT,	0.96,  0.82);

		osd.createButton( bbsl, -0.96, 0.92, CMD_PREVPARTPAGE, null );
		osd.createButton( bbsr, 0.96, 0.92, CMD_NEXTPARTPAGE, null );

		osd.createButton( bek, 0.08, -0.92, CMD_MAIN3, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_MAIN3, this );
		osd.hideGroup( parts3Group = osd.endGroup() );

		//----------------------------------------Akatreszlista oldalak 4
		osd.createBG( new ResourceRef(misc.catalog:0x001Er) );

		pageNumberL[3] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_LEFT,	-0.96,  0.82);
		pageNumberR[3] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_RIGHT,	0.96,  0.82);

		osd.createButton( bbsl, -0.96, 0.92, CMD_PREVPARTPAGE, null );
		osd.createButton( bbsr, 0.96, 0.92, CMD_NEXTPARTPAGE, null );

		osd.createButton( bek, 0.08, -0.92, CMD_MAIN4, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_MAIN4, this );
		osd.hideGroup( parts4Group = osd.endGroup() );

		//----------------------------------------Akatreszlista oldalak 5
		osd.createBG( new ResourceRef(misc.catalog:0x001Fr) );

		pageNumberL[4] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_LEFT,	-0.96,  0.82);
		pageNumberR[4] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_RIGHT,	0.96,  0.82);

		osd.createButton( bbsl, -0.96, 0.92, CMD_PREVPARTPAGE, null );
		osd.createButton( bbsr, 0.96, 0.92, CMD_NEXTPARTPAGE, null );

		osd.createButton( bek, 0.08, -0.92, CMD_MAIN5, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_MAIN5, this );
		osd.hideGroup( parts5Group = osd.endGroup() );

		//----------------------------------------Altalanos decallista oldal

		osd.createBG( new ResourceRef(misc.catalog:0x0022r) );

		Style dbs = new Style( 0.45, 0.45, Frontend.largeFont, Text.ALIGN_CENTER, Osd.RRT_TEST );

		curDecals = new Decal[8];
		decalButtons=new Button[8];
		decalButtons[0] = osd.createButton( dbs, -0.75, -0.35, "", CMD_DB0 );
		decalButtons[1] = osd.createButton( dbs, -0.25, -0.35, "", CMD_DB1 );
		decalButtons[2] = osd.createButton( dbs,  0.25, -0.35, "", CMD_DB2 );
		decalButtons[3] = osd.createButton( dbs,  0.75, -0.35, "", CMD_DB3 );
		decalButtons[4] = osd.createButton( dbs, -0.75,  0.40, "", CMD_DB4 );
		decalButtons[5] = osd.createButton( dbs, -0.25,  0.40, "", CMD_DB5 );
		decalButtons[6] = osd.createButton( dbs,  0.25,  0.40, "", CMD_DB6 );
		decalButtons[7] = osd.createButton( dbs,  0.75,  0.40, "", CMD_DB7 );

		pageNumberL[5] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_LEFT,	-0.96,  0.82);
		pageNumberR[5] = osd.createText( null, Frontend.mediumFont, Text.ALIGN_RIGHT,	0.96,  0.82);

		osd.createButton( bbsl, -0.96, 0.92, CMD_PREVDECALPAGE, null );
		osd.createButton( bbsr, 0.96, 0.92, CMD_NEXTDECALPAGE, null );

		osd.createButton( bek, 0.08, -0.92, CMD_MAIN6, null );
		osd.createButton( bex, 0.92, -0.92, CMD_EXIT, null );

		osd.createHotkey( Input.AXIS_CANCEL, Input.VIRTUAL, CMD_MAIN6, this );
		osd.hideGroup( decalsGroup = osd.endGroup() );

		//------------------------------------------

		refreshMoneyString();
		refreshPage();
	}	


	public void changeGroup(int group)
	{
		if( actGroup != group )
		{
			if (actGroup >= 0)
			{
				osd.hideGroup (actGroup);

				//group deinit code:
				if( actGroup == decalsGroup )
				{
					clearDecalButtons();
				}
				else
				if( actGroup >= parts1Group && actGroup <= parts5Group )
				{
					clearObjectCache();
				}
			}

			actGroup = group;

			if (actGroup >= 0)
			{
				osd.showGroup (actGroup);
				osd.changeSelection2( -1, 0 );
			}
		}
	}


	public void refreshMoneyString()
	{
		new SfxRef( Frontend.SFX_MONEY ).play(); 
		moneytxt.changeText( "$" + Integer.toString( player.money ) );
	}

	public void refreshPage()
	{
		if( pageNumberPrefix )
		{
			pgNumberL.changeText( pageNumberPrefix + curpage );
			pgNumberR.changeText( pageNumberPrefix + (curpage+1) );
		}
	}

//----------------------------------------------------------------------

	public void decalButtonPressed( int n )
	{
		if( showDecals+n < decals.size() )
		{
			int price=DECALPRICE;
			if( price <= player.money )
			{
				Decal decal = decals.elementAt( showDecals+n );

				Dialog dialog = new YesNoDialog( player.controller, Dialog.DF_MODAL|Dialog.DF_DEFAULTBG, "BUY DECAL SET", "Do you want to buy this decal set for $" + price + " ?\n(Each set contains 5 decals)" );
				if( dialog.display() == 0 )
				{
					player.money-=price;
					player.decals.addElement( new Decal( decal.id() ) );
					refreshMoneyString();
				}
			}
			else
			{
				new WarningDialog( player.controller, Dialog.DF_MODAL|Dialog.DF_DEFAULTBG, "NOT ENOUGHT MONEY", "You don't have $" + price + " to buy a decal!" ).display();
			}
		}
	}

//----------------------------------------------------------------------
	public void osdCommand( int cmd )
	{
		if( cmd==CMD_EXIT )							//main index pages
		{
			changeGroup( -1 );
			GameLogic.changeActiveSection( GameLogic.garage );
		}
		else
		if( cmd==CMD_FRONTPAGE )
		{
			changeGroup( mainGroup );
		}
		else
		if( cmd==CMD_MAIN1 )
		{
			pgNumberL=pageNumberL[0];
			pgNumberR=pageNumberR[0];
			changeGroup( main1Group );
		}
		else
		if( cmd==CMD_MAIN2 )
		{
			pgNumberL=pageNumberL[1];
			pgNumberR=pageNumberR[1];
			changeGroup( main2Group );
		}
		else
		if( cmd==CMD_MAIN3 )
		{
			pgNumberL=pageNumberL[2];
			pgNumberR=pageNumberR[2];
			changeGroup( main3Group );
		}
		else
		if( cmd==CMD_MAIN4 )
		{
			pgNumberL=pageNumberL[3];
			pgNumberR=pageNumberR[3];
			changeGroup( main4Group );
		}
		else
		if( cmd==CMD_MAIN5 )
		{
			pgNumberL=pageNumberL[4];
			pgNumberR=pageNumberR[4];
			changeGroup( main5Group );
		}
		else
		if( cmd==CMD_MAIN6 )
		{
			pgNumberL=pageNumberL[5];
			pgNumberR=pageNumberR[5];
			changeGroup( main6Group );
		}
		else
		if( cmd>=CMD_DB0 && cmd<=CMD_DB7 )			//decal buttons
		{
			decalButtonPressed( cmd - CMD_DB0 );
		}
		if( cmd>=CMD_MAIN6_1 && cmd<=CMD_MAIN6_7 )	//decal subsections
		{
			String decalsDir;
			if( cmd == CMD_MAIN6_1 )
			{
				pageNumberPrefix="D-I/";
				decalsDir = "manufacturers";
			}
			else
			if( cmd == CMD_MAIN6_2 )
			{
				pageNumberPrefix="D-II/";
				decalsDir = "logos";
			}
			else
			if( cmd == CMD_MAIN6_3 )
			{
				pageNumberPrefix="D-III/";
				decalsDir = "numbers";
			}
			else
			if( cmd == CMD_MAIN6_4 )
			{
				pageNumberPrefix="D-IV/";
				decalsDir = "digits";
			}
			else
			if( cmd == CMD_MAIN6_5 )
			{
				pageNumberPrefix="D-V/";
				decalsDir = "smilies";
			}
			else
			if( cmd == CMD_MAIN6_6 )
			{
				pageNumberPrefix="D-VI/";
				decalsDir = "animals";
			}
			else
			if( cmd == CMD_MAIN6_7 )
			{
				pageNumberPrefix="D-VII/";
				decalsDir = "misc";
			}

			decals = collectDecals( decalsDir );

			curpage=1;
			showDecals=0;

			setDecalButtons();
			refreshPage();
			changeGroup( decalsGroup );
		}
		else
		if( cmd == CMD_PREVDECALPAGE )					//page control
		{
			if( showDecals >= decalButtons.length )
			{
				showDecals-=decalButtons.length;
				setDecalButtons();

				curpage-=2;
				refreshPage();
			}
		}
		else
		if( cmd == CMD_NEXTDECALPAGE )
		{
			int	max = decals.size();
			if( showDecals+decalButtons.length < max )
			{
				showDecals+=decalButtons.length;
				setDecalButtons();

				curpage+=2;
				refreshPage();
			}
		}
		else
		if( cmd == CMD_PREVPARTPAGE )
		{
			if( inventory.upScroll() )
			{
				curpage-=2;
				refreshPage();
			}
		}
		else
		if( cmd == CMD_NEXTPARTPAGE )
		{
			//biztositsuk, hogy a kov oldal is tele van (az init csak a legelsot tolti fel rendesen!)
			//ha az user cselez, atugrik masik sectionbe, aztan visszalapoz, megszivja!
			collectObjectsStep( 8 );

			if(	inventory.downScroll() )
			{
				curpage+=2;
				refreshPage();
			}
		}
		else
		if( cmd >= CMD_MAIN1_1 && cmd < CMD_MAIN6_1 )	//all alkatresz listaoldal
		{
			collectObjectsBegin();
			if( cmd >= CMD_MAIN1_1 && cmd < CMD_MAIN2_1 ) //all engine part page
			{
				changeGroup( parts1Group );

				if( cmd == CMD_MAIN1_1 )						//engine subsections
				{
					pageNumberPrefix="E-I/";
					collectObjects( new GameRef(parts:0xF227r) );
				}
				else
				if( cmd == CMD_MAIN1_2 )
				{
					pageNumberPrefix="E-II/";
					collectObjects( new GameRef(parts:0xF254r) );
				}
				else
				if( cmd == CMD_MAIN1_3 )
				{
					pageNumberPrefix="E-III/";
					collectObjects( new GameRef(parts:0xF24Dr) );
				}
				else
				if( cmd == CMD_MAIN1_4 )
				{
					pageNumberPrefix="E-IV/";
					collectObjects( new GameRef(parts:0xF23Ar) );
				}
				else
				if( cmd == CMD_MAIN1_5 )
				{
					pageNumberPrefix="E-V/";
					collectObjects( new GameRef(parts:0xF239r) );
				}
				else
				if( cmd == CMD_MAIN1_6 )
				{
					pageNumberPrefix="E-VI/";
					collectObjects( new GameRef(parts:0xF27Dr) );
				}
				else
				if( cmd == CMD_MAIN1_7 )
				{
					pageNumberPrefix="E-VII/";
					collectObjects( new GameRef(parts:0xF23Cr) );
				}
			}
			else
			if( cmd >= CMD_MAIN2_1 && cmd < CMD_MAIN3_1 )		//body subs
			{
				changeGroup( parts2Group );
				if( cmd == CMD_MAIN2_1 )					
				{
					pageNumberPrefix="B-I/";
					collectObjects( new GameRef(parts:0xF242r) );
				}
				else
				if( cmd == CMD_MAIN2_2 )					
				{
					pageNumberPrefix="B-II/";
					collectObjects( new GameRef(parts:0xF24Fr) );
				}
				else
				if( cmd == CMD_MAIN2_3 )					
				{
					pageNumberPrefix="B-III/";
					collectObjects( new GameRef(parts:0xF24cr) );
				}
				else
				if( cmd == CMD_MAIN2_4 )				
				{
					pageNumberPrefix="B-IV/";
					collectObjects( new GameRef(parts:0xF24Br) );
				}
				else
				if( cmd == CMD_MAIN2_5 )				
				{
					pageNumberPrefix="B-V/";
					collectObjects( new GameRef(parts:0xF233r) );
				}
				else
				if( cmd == CMD_MAIN2_6 )				
				{
					pageNumberPrefix="B-VI/";
					collectObjects( new GameRef(parts:0xF228r) );
				}
				else
				if( cmd == CMD_MAIN2_7 )				
				{
					pageNumberPrefix="B-VII/";
					collectObjects( new GameRef(parts:0xF23Br) );
				}
			}
			if( cmd >= CMD_MAIN3_1 && cmd < CMD_MAIN4_1 )
			{
				changeGroup( parts3Group );
				if( cmd == CMD_MAIN3_1 )						//running gear subsections
				{
					pageNumberPrefix="R-I/";
					collectObjects( new GameRef(parts:0xF229r) );
				}
				else
				if( cmd == CMD_MAIN3_2 )
				{
					pageNumberPrefix="R-II/";
					collectObjects( new GameRef(parts:0xF22Br) );
				}
				else
				if( cmd == CMD_MAIN3_3 )
				{
					pageNumberPrefix="R-III/";
					collectObjects( new GameRef(parts:0xF22Dr) );
				}
				else
				if( cmd == CMD_MAIN3_4 )
				{
					pageNumberPrefix="R-IV/";
					collectObjects( new GameRef(parts:0xF235r) );
				}
				else
				if( cmd == CMD_MAIN3_5 )
				{
					pageNumberPrefix="R-V/";
					collectObjects( new GameRef(parts:0xF23Dr) );
				}
				else
				if( cmd == CMD_MAIN3_6 )
				{
					pageNumberPrefix="R-VI/";
					collectObjects( new GameRef(parts:0xF23Er) );
				}
//				else
//				if( cmd == CMD_MAIN3_7 )
//				{
//					pageNumberPrefix="R-VII/";
//					collectObjects( new GameRef(parts:0xF249r) );
//				}
			}
			else
			if( cmd >= CMD_MAIN4_1 && cmd < CMD_MAIN5_1 )
			{
				changeGroup( parts4Group );
				if( cmd == CMD_MAIN4_1 )						//interior subsection
				{
					pageNumberPrefix="I-I/";
					collectObjects( new GameRef(parts:0xF243r) );	//steerwheels
				}
				else
				if( cmd == CMD_MAIN4_2 )
				{
					pageNumberPrefix="I-II/";
					collectObjects( new GameRef(parts:0xF245r) );	//dashes
				}
				else
				if( cmd == CMD_MAIN4_3 )
				{
					pageNumberPrefix="I-III/";
					collectObjects( new GameRef(parts:0xF23fr) );	//gearknobs
				}
				else
				if( cmd == CMD_MAIN4_4 )
				{
					pageNumberPrefix="I-IV/";
					collectObjects( new GameRef(parts:0xF241r) );	//pedals
				}
				else
				if( cmd == CMD_MAIN4_5 )
				{
					pageNumberPrefix="I-V/";
					collectObjects( new GameRef(parts:0xF244r) );	//gauges
				}
				else
				if( cmd == CMD_MAIN4_6 )
				{
					pageNumberPrefix="I-VI/";
					collectObjects( new GameRef(parts:0xF246r) );	//seats
				}
				else
				if( cmd == CMD_MAIN4_7 )
				{
					pageNumberPrefix="I-VII/";
					collectObjects( new GameRef(parts:0xF247r) );	//rollbars
				}
				else
				if( cmd == CMD_MAIN4_8 )
				{
					pageNumberPrefix="I-VIII/";
					collectObjects( new GameRef(parts:0xF248r) );	//decoration
				}
			}
			if( cmd >= CMD_MAIN5_1 && cmd < CMD_MAIN6_1 )
			{
				changeGroup( parts5Group );
				if( cmd == CMD_MAIN5_1 )				//audio subsection
				{
					pageNumberPrefix="A-I/";
					collectObjects( new GameRef(parts:0xF240r) );	//head units
				}
				else
				if( cmd == CMD_MAIN5_2 )				//audio subsection
				{
					pageNumberPrefix="A-II/";
					collectObjects( new GameRef(parts:0x0246r) );	//head units
				}
				else
				if( cmd == CMD_MAIN5_3 )				//audio subsection
				{
					pageNumberPrefix="A-III/";
					collectObjects( new GameRef(parts:0x0247r) );	//head units
				}
				else
				if( cmd == CMD_MAIN5_4 )				//audio subsection
				{
					pageNumberPrefix="A-IV/";
					collectObjects( new GameRef(parts:0x0248r) );	//head units
				}
				else
				if( cmd == CMD_MAIN5_5 )				//audio subsection
				{
					pageNumberPrefix="A-V/";
					collectObjects( new GameRef(parts:0x024Br) );	//head units
				}
				else
				if( cmd == CMD_MAIN5_6 )				//audio subsection
				{
					pageNumberPrefix="A-VI/";
					collectObjects( new GameRef(parts:0x025Br) );	//head units
				}
			}

			collectObjectsEnd();
			refreshPage();
		}
	}
}

//----------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------

public class CatalogInventory extends VisualInventory
{
	Osd			osd;	//for da namez
	TextBox[]	names;

	Catalog	catalog;

	public CatalogInventory( Catalog cat, Player player, float left, float top, float width, float height )
	{
		super(player, left, top, width, height );
		catalog=cat;
	}
		
	public void initVisuals( float left, float top, float width, float height  )
	{
		linesPerPage=2;
		partsPerLine=4;

		//mely itemek lehetnek lathatoak kezdetben?
		cline=0;
		start = cline * partsPerLine;
		stop = start + linesPerPage * partsPerLine;

		//0..1 viewport coordinatarendszerben!
		float	itemWidth=0.20, itemHeight=0.15;
		float	hSpacing = (width-itemWidth*partsPerLine)/partsPerLine;
		float	vSpacing = (height-itemHeight*linesPerPage)/(linesPerPage-1);
		
		//backObject = new RenderRef( misc.catalog:0x00000020r );
		panels=new InventoryPanel[partsPerLine*linesPerPage];
		names=new TextBox[panels.length];

		//eggyel magasabb pri vp kell, mint maga a katalogus, kulonben eltunnek a szovegek!
		osd = new Osd( 1.0, 0.0, 11 );
		osd.iLevel = Osd.IL_NONE;

		int	index;
		float cheight=top;
		for( int i=0; i<linesPerPage; i++ )
		{
			float cwidth=left;
			for( int j=0; j<partsPerLine; j++ )
			{
				if( j == partsPerLine/2 )
					cwidth+=hSpacing;

				index = i*partsPerLine+j; 
				panels[index]=new CatalogInventoryPanel( this, index, cwidth, cheight, itemWidth, itemHeight, player );
				names[index]=osd.createTextBox( null, Frontend.smallFont, Text.ALIGN_CENTER, (cwidth)*2-1, ((cheight+itemHeight)*2)-1, itemWidth*2 );
				//kicsit patch, sajnos a fontnak nics olyan propertyje, hogy multicolor-e!
				if( Frontend.smallFont.id() == Text.RID_CONSOLE10 || Frontend.smallFont.id() == Text.RID_CONSOLE5 )
					names[index].changeColor( 0xFF000000 );

				cwidth+=itemWidth+hSpacing;
			}
			cheight+=itemHeight+vSpacing;
		}
	}

	public int upScroll()
	{
		if( cline )
		{
			cline-=linesPerPage;
			update();
			return 1;
		}
		return 0;
	}

	public int downScroll()
	{
		if( cline+linesPerPage < pages()*linesPerPage )
		{
			cline+=linesPerPage;
			update();
			return 1;
		}
		return 0;
	}

	//number of twin pages in a catalog section
	public int	pages()
	{
		if( items.size() > 1)
			return (items.size()-1)/(partsPerLine*linesPerPage)+1;
			
		return 1;
	}

	public void panelLeftClick( int index )
	{
		index += currentLine()*partsPerLine;

		if( index<items.size() )
		{
			InventoryItem item = items.elementAt( index );

			int price = item.getPrice() * Catalog.PRICERATIO;
			if( price <= player.money )
			{
				Dialog d = new BuyCatalogItemDialog( player.controller, Dialog.DF_MODAL|Dialog.DF_DEFAULTBG|Dialog.DF_WIDE, item, price );

				if( d.display() == 0 )
				{
					player.money-= price;
					item.copyToInventory( player.parts );
					catalog.refreshMoneyString();
					//kap egy bonus matricat is, ha spec alkatresz:
					int decalID = item.getLogo();
					if( decalID )
					{
						player.decals.addElement( new Decal( decalID ) );
					}
				}
			}
			else
			{
				new WarningDialog( player.controller, Dialog.DF_MODAL|Dialog.DF_DEFAULTBG, "NOT ENOUGHT MONEY", "You don't have enought money to buy this part!" ).display();
			}
		}
	}

	public void update()
	{
		//hol kapcsolodnak ki a buttonok?
		int begin = start;
		int end = stop;

		//mibol lesznek buttonok?
		start = cline * partsPerLine;
		stop = start + linesPerPage * partsPerLine;

		int i, vis;

		//clear changed ones
		vis=0;
		for( i=begin; i<end; i++ )
		{
			names[vis++].changeText( null );
		}

		//add new ones
		vis=0;
		for( i=start; i<stop; i++ )
		{
			if( i<items.size() )
			{
				InventoryItem item = items.elementAt(i);
				names[vis++].changeText( item.getName() + " $"+ (int)(item.getPrice() * Catalog.PRICERATIO) );
			}
		}

		super.update();
	}

	public void show()
	{
		super.show();
		osd.show();
	}

	public void hide()
	{
		osd.hide();
		super.hide();
	}
}

//----------------------------------------------------------------------------------------------

public class CatalogInventoryPanel extends InventoryPanel
{
	Player	player;

	ResourceRef	infoTex0, infoTex1;
	Rectangle infoRect0, infoRect1;

	public CatalogInventoryPanel( CatalogInventory inventory, int index, float left, float top, float width, float height, Player p )
	{
		super( inventory, index, left, top, width, height );

		infoRect0 = inventory.osd.createRectangle( (left+width/2)*2-1, ((top-0.04)*2)-1, 0.1, 0.1, 1.0, -0.5, 0.0, 0, null );
		infoRect1 = inventory.osd.createRectangle( (left+width/2)*2-1, ((top-0.04)*2)-1, 0.1, 0.1, 1.0,  0.5, 0.0, 0, null );
		player = p;
	}

	public void swap( int index_a, int index_b )
	{
		//nincs swap!!
	}

	public void attachItem( InventoryItem invitem )
	{
		ypr = new Ypr( -1.4, -0.7, 0.0 );

		super.attachItem( invitem );

		infoTex0 = infoTex1 = null;

		if( invitem && invitem instanceof InventoryItem_Part)
		{
			((InventoryItem_Part)invitem).compatibility = 0;

			Part p=invitem.getPart();
			if( player.car )
				if( p.getInfo( p.GII_COMPATIBLE, player.car.id() + "" ) )
				{
					if( p.getInfo( p.GII_INSTALL_OK, player.car.id() + "" ) )
					{
						infoTex0 = Catalog.RR_ICON_CAR_1STEP;
						((InventoryItem_Part)invitem).compatibility |= 1;
					}
					else
					{
						infoTex0 = Catalog.RR_ICON_CAR_COMP;
						((InventoryItem_Part)invitem).compatibility |= 2;
					}
				}


			int compatibleParts;
			for( int i=player.parts.size()-1; i>=0; i-- )
			{
				if( player.parts.items.elementAt(i) instanceof InventoryItem_Part )
					if( p.getInfo( p.GII_INSTALL_OK, player.parts.items.elementAt(i).getPart().id() + "" ) )
					{
						compatibleParts++;
						((InventoryItem_Part)invitem).compatibility |= 4;
						break;	//inkabb ne nezzuk tovabb, lassit
					}
			}

			if( compatibleParts )
				infoTex1 = Catalog.RR_ICON_INV_COMP;
			
		}

		infoRect0.changeTexture( infoTex0 );
		infoRect1.changeTexture( infoTex1 );
	}

}

public class BuyCatalogItemDialog extends YesNoDialog
{
	public BuyCatalogItemDialog( Controller ctrl, int myflags, InventoryItem item, int price )
	{ 
		super( ctrl, myflags, "BUY PART", genBody( item, price) ); 
	}

	public String genBody( InventoryItem item, int price )
	{
//		String body = "Do you want to buy this " + item.getName()  + " for $" + price + " ? \n \n Short description: " + item.getDescription() + " \n \n Note: ";
		String body = "Do you want to buy this " + item.getName()  + " for $" + price + " ? \n \n Note: ";		

		if( item instanceof InventoryItem_Part )
		{
			if( !((InventoryItem_Part)item).compatibility )
				body = body + "NOT compatible with you current car / parts bin!";
			else
			{
				if( ((InventoryItem_Part)item).compatibility & 1 )
					body = body + "installable right away to your car";
				if( ((InventoryItem_Part)item).compatibility & 2 )
					body = body + "interchangeable with your cars parts";
				if( ((InventoryItem_Part)item).compatibility & 4 )
				{
					if( ((InventoryItem_Part)item).compatibility & 3 )
						body = body + " and ";
					body = body + "parts bin compatible";
				}

			}
		}

		return body;
	}
}
