package java.game;

import java.io.*;
import java.util.*;
import java.util.resource.*;
import java.render.*;	//Text
import java.render.osd.*;	//Text
import java.sound.*;

public class TestTrack extends Track
{
	final static int MPH_60 = 771.604938271604938271604938271605;
	final static int MPH_124 = 3086.41975308641975308641975308642;

	Vector3 posExit = new Vector3( -456,0.0,-584 );
	Ypr		oriExit = new Ypr( 3.0, 0.0, 0.0 );

	Text	messageTextA;
	Text	messageTextB;
	Text	messageText0;
	Text	messageText1;
	Text	messageText2;

	int		testStatus = 0;
	int		triggerIndex = 0;
	int		acceleration = 0;
	int		acceleration120 = 0;
	float	testStartTime = 0.0f;

	Round	actRound = null;
	Round[]	round = new Round[2];
	int		rounds = 2;

	public TestTrack()
	{
		map = new GroundRef( maps.test_track:0x00000001r );
		nav = new Navigator( -5.317-2.64, -15.996, 2.64, maps.test_track.smallmap:0x00000001r, maps.test_track.smallmap:0x00000002r, maps.test_track.smallmap:0x00000005r, 6, 8, 10 );
	}

	public void enter( GameState prev_state )
	{
		Frontend.loadingScreen.show();
		GfxEngine.flush();

		if( prev_state instanceof Garage )
		{
			posStart=posExit;
			oriStart=oriExit;
		}

		// 1/4 miles
		round[0] = new Round( this, "Go straight ahead", "to time the accelearation of your car!" );
		round[0].startdir( 3.14 );
		round[0].point( 0.000, 0.000, -1461.785, 1, 10 );
		round[0].point( 0.000, 0.000, -1059.785, 1, 20 );	//quartermile
		round[0].point( 0.000, 0.000, 148.215, 1, 20 );		//mile

		round[1] = new Round( this, "Test lap time!", "GO!" );
		round[1].startdir( 3.14 );
		round[1].point( -450.598, 0.000, -524.816, 1 );
		round[1].point( -450.598, 0.000, -223.142, 1 );
		round[1].point( -444.736, 1.011, 72.270, 1 );
		round[1].point( -27.535, 1.425, 450.475, 1 );
		round[1].point( 444.689, 1.011, 72.560, 1 );
		round[1].point( 450.598, 0.000, -223.142, 1 );
		round[1].point( 450.598, 0.000, -544.816, 1 );
		round[1].point( 450.598, 0.000, -893.995, 1 );
		round[1].point( 446.293, 0.965, -1124.731, 1 );
		round[1].point( -40.000, 1.425, -1513.328, 1 );	
		round[1].point( -446.000, 1.425, -1124.000, 1 );
		round[1].point( -450.598, 0.000, -893.996, 1 );
		round[1].loop();

		actRound = null;

		super.enter( prev_state );

		messageTextA = osd.createText( "", Frontend.largeFont, Text.ALIGN_CENTER, 0.0, -0.8 );
		messageTextB = osd.createText( "", Frontend.largeFont, Text.ALIGN_CENTER, 0.0, -0.7 );
		messageText0 = osd.createText( "", Frontend.largeFont, Text.ALIGN_RIGHT, 0.0, -0.7 );
		messageText1 = osd.createText( "", Frontend.largeFont, Text.ALIGN_LEFT, 0.0, -0.7 );
		messageText2 = osd.createText( "", Frontend.largeFont, Text.ALIGN_CENTER, 0.0, -0.6 );
	}

	public void exit( GameState next_state )
	{
        if( !(next_state instanceof RaceSetup) )
			removeAllTimers();

		if( round[0] )
		{
			round[0].destroy();
			round[0] = null;
		}
		if( round[1] )
		{
			round[1].destroy();
			round[1] = null;
		}

		super.exit( next_state );
	}

	public void event_handlerTrigger( GameRef obj_ref, int event, String param )
	{
		int	id = param.token(0).intValue();
		if (id == player.car.id())
		{
			if( event == EVENT_TRIGGER_ON )
			{
				if( !activeTrigger )
				{
					activeTrigger=obj_ref.id();
				}
			}
			else
			{
				activeTrigger=0;
			}
		}
	}

	public void handleEvent( GameRef obj_ref, int event, int param )
	{
		super.handleEvent( obj_ref, event, param );

		if( event == EVENT_TIME )
		{
			if( param == 2 )	//one sec tick
			{
				if( activeTrigger )
				{
					if( player.car.getSpeedSquare() < 0.25 )	//slow speed?
					{	
						for( int i = 0; i < rounds; i++ )
						{
							if( round[i] )
							{
								if( activeTrigger == round[i].trigger.elementAt(0).trigger.id() )
								{
									Ypr ypr = player.car.getOri();

									float diff = ypr.y-round[i].startOri.y;
									if( diff >= 3.14 )
										diff = 6.28 - diff;
									if( diff <= -3.14 )
										diff = -6.28 - diff;

									if( diff < 0.5f && diff > -0.5f)
									{
										actRound = round[i];
										testStatus = 0;
										triggerIndex = 1;
										if( actRound.type == 0 )
										{
											acceleration = 1;
											acceleration120 = 1;
										}
										else
										{
											acceleration = 0;
											acceleration120 = 0;
										}
									}
								}
							}
						}
					}
				}
				else
				{
				}
			}
		}
	}

	public void animate()
	{
		super.animate();

		if( actRound )
		{
			float speedSquare = player.car.getSpeedSquare();

			if( player.car.maxTestTrackSpeedSq < speedSquare )
				player.car.maxTestTrackSpeedSq = speedSquare;

			if( testStatus == 0 )
			{
				messageTextA.changeText( actRound.messageA );
				messageTextB.changeText( actRound.messageB );
				messageText0.changeText( "" );
				messageText1.changeText( "" );
				messageText2.changeText( "" );
				testStatus = 1;
			}
			if( testStatus == 1 )
			{
				if( speedSquare > 0.25 )
				{
					messageTextA.changeText( "" );
					messageTextB.changeText( "" );
					messageText0.changeText( "Time: " );
					testStartTime = System.simTime();
					testStatus = 2;
					Sound.changeMusicSet( Sound.MUSIC_SET_RACE );
				}
			}
			if( testStatus == 2 )
			{
				float	time = System.simTime() - testStartTime;
				messageText1.changeText( String.timeToString( time, String.TCF_NOHOURS ) + " s" );
				if( acceleration )
				{
					if( speedSquare >= MPH_60 )
					{
						messageText2.changeText( "Acceleration 0-100 KPH (0-62.1 MPH): " + String.timeToString( time, String.TCF_NOHOURS ) + " s" );
						acceleration = 0;
						if( player.car.bestTestTrackAcc > time || player.car.bestTestTrackAcc < 0.10 )
							player.car.bestTestTrackAcc = time;
					}
				}
				if( acceleration120 )
				{
					if( speedSquare >= MPH_124 )
					{
						messageText2.changeText( "Acceleration 0-200 KPH (0-124.2 MPH): " + String.timeToString( time, String.TCF_NOHOURS ) + " s" );
						acceleration120 = 0;
						if( player.car.bestTestTrackAcc120 > time || player.car.bestTestTrackAcc120 < 0.10 )
							player.car.bestTestTrackAcc120 = time;
					}
				}
				if( activeTrigger )
				{
					Trigger tr = actRound.trigger.elementAt( triggerIndex );
					if( activeTrigger == tr.trigger.id() )
					{
						if( triggerIndex == 1 ) // 402 m //
						{
							if( actRound.type == 0 )
							{
								messageText2.changeText( "1/4 mile time: " + String.timeToString( time, String.TCF_NOHOURS ) + " s" );
								if( player.car.bestTestTrackTime2 > time || player.car.bestTestTrackTime2 < 0.10 )
								{
									player.car.bestTestTrackTime2_speedSq = speedSquare;
									player.car.bestTestTrackTime2 = time;
								}
							}
						}
						triggerIndex++;
						if( triggerIndex == actRound.trigger.size() )
						{
							if( actRound.type == 0 )
							{
								messageText2.changeText( "1 mile time: " + String.timeToString( time, String.TCF_NOHOURS ) + " s" );
								if( player.car.bestTestTrackTime0 > time || player.car.bestTestTrackTime0 < 0.10 )
								{
									player.car.bestTestTrackTime0_speedSq = speedSquare;
									player.car.bestTestTrackTime0 = time;
								}
							}
							else
							{
								if( player.car.bestTestTrackTime1 > time || player.car.bestTestTrackTime1 < 0.10 )
									player.car.bestTestTrackTime1 = time;
							}
							actRound = null;
							Sound.changeMusicSet( Sound.MUSIC_SET_DRIVING );
						}
					}
				}
			}
		}
	}

}


