package java.game.parts.engines.Einvagen_Duhen_Ishima_Focer;

import java.util.*;
import java.util.resource.*;
import java.game.*;
import java.game.parts.*;
import java.game.parts.enginepart.slidingenginepart.*;
import java.game.parts.enginepart.slidingenginepart.reciprocatingenginepart.*;


public class Einvagen_PerPro_GTA_transmission_RWD_extension extends ReciprocatingEnginePart
{
	public Einvagen_PerPro_GTA_transmission_RWD_extension( int id )
	{
		super( id );
		name = "Einvagen GTA transmission center differential";
		description = "This is center differential is used in the Einvagen GTA. \n It splits the torque 40-60 front-rear. Unfortunately these values cannot be modified, but it's perfect for the stock car as it is.";

		value = tHUF2USD(180);
		brand_new_prestige_value = 44.70;
		setMaxWear(kmToMaxWear(600000.0));

		maxRPM = 10000.0;
		inertia = kgToInertia(1.1);
	}

	public void fillDynoData( DynoData dd, int parentSlot )	//different in other (engine) part classes
	{
		super.fillDynoData( dd, parentSlot );

		if (the_car)
		{
			the_car.drive_type |= the_car.DT_RWD;
		}
	}
}
